/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tfloat;

import cern.colt.function.tfloat.FloatIntProcedure;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tbyte.ByteArrayList;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.map.HashFunctions;
import cern.colt.map.tfloat.AbstractFloatIntMap;

public class OpenFloatIntHashMap
extends AbstractFloatIntMap {
    private static final long serialVersionUID = 1L;
    protected float[] table;
    protected int[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenFloatIntHashMap() {
        this(277);
    }

    public OpenFloatIntHashMap(int n) {
        this(n, 0.2, 0.5);
    }

    public OpenFloatIntHashMap(int n, double d, double d2) {
        this.setUp(n, d, d2);
    }

    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        OpenFloatIntHashMap openFloatIntHashMap = (OpenFloatIntHashMap)super.clone();
        openFloatIntHashMap.table = (float[])openFloatIntHashMap.table.clone();
        openFloatIntHashMap.values = (int[])openFloatIntHashMap.values.clone();
        openFloatIntHashMap.state = (byte[])openFloatIntHashMap.state.clone();
        return openFloatIntHashMap;
    }

    public boolean containsKey(float f) {
        return this.indexOfKey(f) >= 0;
    }

    public boolean containsValue(int n) {
        return this.indexOfValue(n) >= 0;
    }

    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    public boolean forEachKey(FloatProcedure floatProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || floatProcedure.apply(this.table[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachPair(FloatIntProcedure floatIntProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || floatIntProcedure.apply(this.table[n], this.values[n])) continue;
            return false;
        }
        return true;
    }

    public int get(float f) {
        int n = this.indexOfKey(f);
        if (n < 0) {
            return 0;
        }
        return this.values[n];
    }

    protected int indexOfInsertion(float f) {
        float[] fArray = this.table;
        byte[] byArray = this.state;
        int n = fArray.length;
        int n2 = HashFunctions.hash(f) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] == 1 && fArray[n3] != f) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || fArray[n3] != f)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            if (byArray[n3] == 0) {
                n3 = n5;
            }
        }
        if (byArray[n3] == 1) {
            return -n3 - 1;
        }
        return n3;
    }

    protected int indexOfKey(float f) {
        float[] fArray = this.table;
        byte[] byArray = this.state;
        int n = fArray.length;
        int n2 = HashFunctions.hash(f) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        int n4 = n2 % (n - 2);
        if (n4 == 0) {
            n4 = 1;
        }
        while (byArray[n3] != 0 && (byArray[n3] == 2 || fArray[n3] != f)) {
            if ((n3 -= n4) >= 0) continue;
            n3 += n;
        }
        if (byArray[n3] == 0) {
            return -1;
        }
        return n3;
    }

    protected int indexOfValue(int n) {
        int[] nArray = this.values;
        byte[] byArray = this.state;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            if (byArray[n2] != 1 || nArray[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    public float keyOf(int n) {
        int n2 = this.indexOfValue(n);
        if (n2 < 0) {
            return Float.NaN;
        }
        return this.table[n2];
    }

    public void keys(FloatArrayList floatArrayList) {
        floatArrayList.setSize(this.distinct);
        float[] fArray = floatArrayList.elements();
        float[] fArray2 = this.table;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = fArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            fArray[n++] = fArray2[n2];
        }
    }

    public void pairsMatching(FloatIntProcedure floatIntProcedure, FloatArrayList floatArrayList, IntArrayList intArrayList) {
        floatArrayList.clear();
        intArrayList.clear();
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || !floatIntProcedure.apply(this.table[n], this.values[n])) continue;
            floatArrayList.add(this.table[n]);
            intArrayList.add(this.values[n]);
        }
    }

    public boolean put(float f, int n) {
        int n2 = this.indexOfInsertion(f);
        if (n2 < 0) {
            n2 = -n2 - 1;
            this.values[n2] = n;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n3 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
            return this.put(f, n);
        }
        this.table[n2] = f;
        this.values[n2] = n;
        if (this.state[n2] == 0) {
            --this.freeEntries;
        }
        this.state[n2] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n4 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n4);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        float[] fArray = this.table;
        int[] nArray = this.values;
        byte[] byArray = this.state;
        float[] fArray2 = new float[n];
        int[] nArray2 = new int[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = fArray2;
        this.values = nArray2;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            float f = fArray[n3];
            int n4 = this.indexOfInsertion(f);
            fArray2[n4] = f;
            nArray2[n4] = nArray[n3];
            byArray2[n4] = 1;
        }
    }

    public boolean removeKey(float f) {
        int n = this.indexOfKey(f);
        if (n < 0) {
            return false;
        }
        this.state[n] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n2 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n2);
        }
        return true;
    }

    protected void setUp(int n, double d, double d2) {
        int n2 = n;
        super.setUp(n2, d, d2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new float[n2];
        this.values = new int[n2];
        this.state = new byte[n2];
        this.minLoadFactor = d;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0 : d2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    public void values(IntArrayList intArrayList) {
        intArrayList.setSize(this.distinct);
        int[] nArray = intArrayList.elements();
        int[] nArray2 = this.values;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n++] = nArray2[n2];
        }
    }
}

