/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tbyte;

import cern.colt.PersistentObject;
import cern.colt.buffer.tbyte.ByteBufferConsumer;
import cern.colt.list.tbyte.ByteArrayList;

public class ByteBuffer
extends PersistentObject
implements ByteBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected ByteBufferConsumer target;
    protected byte[] elements;
    protected ByteArrayList list;
    protected int capacity;
    protected int size;

    public ByteBuffer(ByteBufferConsumer byteBufferConsumer, int n) {
        this.target = byteBufferConsumer;
        this.capacity = n;
        this.elements = new byte[n];
        this.list = new ByteArrayList(this.elements);
        this.size = 0;
    }

    public void add(byte by) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = by;
    }

    public void addAllOf(ByteArrayList byteArrayList) {
        int n = byteArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(byteArrayList);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

