% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate.R
\name{int_pro}
\alias{int_pro}
\title{Comprehensive Prognostic Modeling Pipeline}
\usage{
int_pro(
  ...,
  model_names = NULL,
  tune = TRUE,
  n_estimators = 10,
  seed = 123,
  time_unit = "day",
  years_to_evaluate = c(1, 3, 5)
)
}
\arguments{
\item{...}{Data frames for survival analysis. First = training; others = test sets.
Format: first column = ID, second = outcome (0/1), third = time, remaining = features.}

\item{model_names}{Character vector specifying which models to use.
If NULL (default), uses all registered prognostic models.}

\item{tune}{Logical, enable tuning. Default TRUE.}

\item{n_estimators}{Integer, bagging iterations. Default 10.}

\item{seed}{Integer for reproducibility. Default 123.}

\item{time_unit}{Time unit in data: "day", "month", or "year". Default "day".}

\item{years_to_evaluate}{Numeric vector of years for time-dependent AUROC. Default c(1,3,5).}
}
\value{
A list with:
\itemize{
\item \code{all_results}: All model outputs
\item \code{cindex_matrix}: C-index values (models × datasets)
\item \code{avg_auroc_matrix}: Average time-dependent AUROC (models × datasets)
\item \code{model_categories}: Model category labels
\item \code{dataset_names}: Dataset identifiers
}
}
\description{
Executes a complete prognostic (survival) modeling workflow including
single models, bagging, and stacking ensembles. Returns C-index and time-dependent
AUROC metrics.
}
\examples{
\dontrun{
prognosis_results <- int_pro(train_pro, test_pro1, test_pro2)
}

}
