% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colombia_presidents.R
\name{get_colombia_presidents}
\alias{get_colombia_presidents}
\title{Get Colombia's Presidents from API Colombia}
\source{
API Colombia: \url{https://api-colombia.com/api/v1/President}
}
\usage{
get_colombia_presidents()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{id}: President identifier (integer)
  \item \code{name}: President's first name(s) (character)
  \item \code{last_name}: President's last name(s) (character)
  \item \code{political_party}: Political party affiliation (character)
  \item \code{start_period_date}: Start date of presidency (character, YYYY-MM-DD format)
  \item \code{end_period_date}: End date of presidency (character, YYYY-MM-DD format or NULL for current)
}
}
\description{
Retrieves comprehensive information about all Colombian presidents from 1886 to present
from the API Colombia service. This function fetches data including names, political parties,
government periods, descriptions, and biographical information for each president.
}
\details{
This function sends a GET request to the API Colombia service.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_colombia_presidents()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
