% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advectionF.R
\name{advectionFrotation}
\alias{advectionFrotation}
\title{Rotational advection field}
\usage{
advectionFrotation(spacepoints, x0, y0, a, b)
}
\arguments{
\item{spacepoints}{vector of coordinates (2 x d), where d is the number of locations/grid points}

\item{x0}{x coordinate of the center of rotation}

\item{y0}{y coordinate of the center of rotation}

\item{a}{parameter controlling the x component of rotational velocity}

\item{b}{parameter controlling the y component of rotational velocity}
}
\description{
Provides an advection field corresponding to rotation around a specified center.
}
\section{Note}{
\itemize{
\item if a > 0, b > 0: clockwise rotation around (x0, y0)
\item if a < 0, b < 0: counter-clockwise rotation around (x0, y0)
}
}

\examples{

library(ggquiver)
library(ggplot2)
## specify coordinates
m = 25
aux <- seq(0, m - 1, length = m)
coord <- expand.grid(aux, aux)

af <- advectionFrotation(spacepoints = coord,
                        x0 = floor(m / 2),
                        y0 = floor(m / 2),
                        a = 3,
                        b = 2)

## visualize advection field
dta <- data.frame(lon = coord[ ,1], lat = coord[ ,2], u = af[ ,1], v = af[ ,2])
ggplot(dta, aes(x = lon, y = lat, u = u, v = v)) +
geom_quiver() +
theme_light()
}
\references{
Papalexiou, S.M., Serinaldi, F., Porcu, E. (2021). Advancing
Space-Time Simulation of Random Fields: From Storms to Cyclones and Beyond.
Water Resources Research, 57, e2020WR029466, \doi{10.1029/2020WR029466}
}
