% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advectionF.R
\name{advectionF}
\alias{advectionF}
\title{Advection fields}
\usage{
advectionF(id, ...)
}
\arguments{
\item{id}{advection type id (\code{uniform}, \code{rotation}, \code{spiral}, \code{spiralCE}, \code{radial}, and \code{hyperbolic})}

\item{...}{other arguments (vector of coordinates and parameters of advection field functions)}
}
\description{
Provides parametric functions that describe different types of advection fields.
}
\examples{

library(ggquiver)
library(ggplot2)

## specify coordinates
m = 25
aux <- seq(0, m - 1, length = m)
coord <- expand.grid(aux, aux)

## get the advection field
af <- advectionF('spiral',
                 spacepoints = coord,
                 x0 = floor(m / 2),
                 y0 = floor(m / 2),
                 a = 3,
                 b = 2,
                 rotation = 1)

## visualize advection field
dta <- data.frame(lon = coord[ ,1], lat = coord[ ,2], u = af[ ,1], v = af[ ,2])
ggplot(dta, aes(x = lon, y = lat, u = u, v = v)) +
geom_quiver() +
theme_light()

}
\references{
Papalexiou, S.M., Serinaldi, F., Porcu, E. (2021). Advancing
Space-Time Simulation of Random Fields: From Storms to Cyclones and Beyond.
Water Resources Research, 57, e2020WR029466, \doi{10.1029/2020WR029466}
}
