% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxSurvey.R
\name{svyBayesmod}
\alias{svyBayesmod}
\title{Bayesian Survey Model Estimation}
\usage{
svyBayesmod(
  svysmpl,
  svypopu,
  outcome_formula,
  BayesFun,
  subset = NULL,
  family = gaussian(),
  invlvls,
  weights = NULL,
  nskip = 1000,
  npost = 1000,
  nchain = 4,
  printmod = TRUE,
  useTrueSample = FALSE,
  stan_verbose = FALSE,
  HPD_CI = FALSE,
  seed = NULL
)
}
\arguments{
\item{svysmpl}{A dataframe or tibble representing the sample data (`samples`). This should contain
the outcome variable and any additional covariates.}

\item{svypopu}{A dataframe or tibble representing the population data (`population`).
This should contain all variables in the model.}

\item{outcome_formula}{A formula for Stan, specifying the outcome and predictors in the model.}

\item{BayesFun}{The name of the Stan function to be used for fitting the Bayesian model.}

\item{subset}{A character vector representing filtering conditions to select subsets of the sample and population.
Default is `NULL`, in which case the analysis is performed on the entire dataset. If specified,
estimates for both the whole data and the subsets will be calculated.}

\item{family}{The distribution family for the outcome variable. Currently, the following options are supported:
\code{\link[stats]{gaussian}} for continuous outcomes and \code{\link[stats]{binomial}} for binary outcomes.}

\item{invlvls}{A numeric vector specifying the confidence levels for the credible intervals (CIs). If more than
one value is specified, multiple CIs will be calculated.}

\item{weights}{A numeric vector of case weights. The length of this vector should match the number of cases in `svysmpl`.
These weights will be used in the Bayesian model for weighted estimation.}

\item{nskip}{An integer specifying the number of burn-in iterations for each chain in the MCMC for Stan models.
Default is 1000.}

\item{npost}{An integer specifying the number of posterior sampling iterations for each chain in the MCMC for Stan models.
Default is 1000.}

\item{nchain}{An integer specifying the number of MCMC chains for Stan models. Default is 4.}

\item{printmod}{A logical scalar; if `TRUE`, posterior estimates will be printed.}

\item{useTrueSample}{A logical scalar; if `TRUE`, the estimator will use true sample information.}

\item{stan_verbose}{A logical scalar; if `TRUE`, MCMC information will be printed during Stan model fitting.}

\item{HPD_CI}{A logical scalar; if `TRUE`, the calculated credible intervals will be highest posterior density intervals (HPD).
Otherwise, symmetric intervals will be used. Default is `FALSE`.}

\item{seed}{An integer specifying the random seed for reproducibility. Default is `NULL`.}
}
\value{
A list containing the Bayesian estimates and confidence intervals (CIs) for each subset or the entire dataset.
        Each element in the list includes:
        - `estimate`: The Bayesian point estimate for the outcome.
        - `CI`: The credible intervals for the outcome estimate.
        - Other elements based on the specified confidence levels in `invlvls`.
}
\description{
This function fits a Bayesian model using Stan for survey data. It allows you to specify
the outcome formula, the function for Stan, and apply different types of survey analysis, including
weighted or unweighted models, for both sample and population data. The function supports
posterior estimation, confidence intervals (CIs), and MCMC diagnostics.
}
\examples{
## Example usage with survey data:
## Simulate sample and population data
data = simulate(N = 3000, discretize = 3, setting = 3, seed = 123)
population = data$population  # Get population data
samples = data$samples        # Get sample data
ipw = 1 / samples$true_pi    # Compute inverse probability weights

## Define outcome formula and Stan function
outcome_formula = "Y1 ~ Z1 + Z2 + Z3 + (1|auX_3)"
BayesFun = "stan_glmer"

## Fit Bayesian model using weighted survey data
bayes_model = svyBayesmod(svysmpl = samples, svypopu = population,
                          outcome_formula = outcome_formula,
                          BayesFun = BayesFun, weights = ipw,
                          family = gaussian(), nskip = 20, npost = 20,
                          nchain = 2, printmod = TRUE, invlvls = 0.95, stan_verbose = TRUE)

}
