% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msg.R
\name{msg}
\alias{msg}
\alias{msg_verbose}
\alias{msg_debug}
\alias{msg_success}
\alias{msg_danger}
\alias{msg_warning}
\alias{msg_info}
\title{Write messages based on verbosity level}
\usage{
msg(
  message,
  levels_to_write = c("minimal", "verbose", "debug"),
  msg_fun = cli::cli_alert,
  ...,
  .envir = parent.frame()
)

msg_verbose(message, msg_fun = cli::cli_alert, ..., .envir = parent.frame())

msg_debug(message, msg_fun = cli::cli_alert, ..., .envir = parent.frame())

msg_success(message, ..., .envir = parent.frame())

msg_danger(message, ..., .envir = parent.frame())

msg_warning(message, ..., .envir = parent.frame())

msg_info(message, ..., .envir = parent.frame())
}
\arguments{
\item{message}{\code{character} string with the text to display.}

\item{levels_to_write}{\code{character} vector with the verbosity levels for
which the message should be displayed. Options are \code{minimal}, \code{verbose}, and
\code{debug}.}

\item{msg_fun}{The function to use for writing the message. Most commonly
from the cli package. Default is \code{cli::cli_alert()}.}

\item{...}{Additional arguments to pass to \code{msg_fun()}}

\item{.envir}{The \code{environment} to use for evaluating the verbosity level.
Default \code{parent.frame()} will be sufficient for most use cases. Parsed on to
\code{msg_fun()}.}
}
\value{
Return from \code{msg_fun()}
}
\description{
The \code{msg()} function is a general utility function for writing messages to
the console based on the \link{verbosity_level} set for your session and package.

For simple messages in your functions the recommended approach is to use the
following wrappers for consistency across packages:
\itemize{
\item \code{msg_success()}: To indicate a successful operation. Wrapper around \code{msg()}
using \code{cli::cli_alert_success()} to display the message.
\item \code{msg_danger()}: To indicate a failed operation. Wrapper around \code{msg()}
using \code{cli::cli_alert_danger()} to display the message.
\item \code{msg_warning()}: To indicate a warning. Wrapper around \code{msg_verbose()}
using \code{cli::cli_alert_warning()} to display the message.
\item \code{msg_info()}: To provide additional information. Wrapper around
\code{msg_verbose()} using \code{cli::cli_alert_info()} to display the message.
}

For more control of how the messages are displayed use:
\itemize{
\item \code{msg()}: To write messages using custom \code{msg_fun} functions and define your
own verbosity levels to write.
\item \code{msg_verbose()}: To write verbose messages with a custom \code{msg_fun}.
\item \code{msg_debug()}: To to report messages only relevant when debugging.
}

For more information on the verbosity levels, see \link{verbosity_level}.
}
\examples{
msg("General message")
msg_success("Operation successful")
msg_danger("Operation failed")
msg_warning("Warning message")
msg_info("Additional information")
}
