% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\encoding{UTF-8}
\name{plot_prob}
\alias{plot_prob}
\title{Probability Plotting Method for Univariate Lifetime Distributions}
\usage{
plot_prob(x, y, event, id = rep("XXXXXX", length(x)),
  distribution = c("weibull", "lognormal", "loglogistic", "normal",
  "logistic", "sev"), title_main = "Probability Plot",
  title_x = "Characteristic", title_y = "Unreliability",
  title_trace = "Sample")
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{y}{a numeric vector which consists of estimated failure probabilities
regarding the lifetime data in \code{x}.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{id}{a character vector for the identification of every unit.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"} or \code{"sev"} \emph{(smallest extreme value)}.
Other distributions have not been implemented yet.}

\item{title_main}{a character string which is assigned to the main title
of the plot.}

\item{title_x}{a character string which is assigned to the title of the
x axis.}

\item{title_y}{a character string which is assigned to the title of the
y axis.}

\item{title_trace}{a character string whis is assigned to the trace shown in
the legend.}
}
\value{
Returns a plotly object containing the layout of the probability plot
  provided by \code{\link{plot_layout}} and the plotting positions.
}
\description{
This function is used to apply the graphical technique of probability
plotting.
}
\details{
The marker label for x is determined by the first word provided in the
argument \code{title_x}, i.e. if \code{title_x = "Mileage in km"} the x label
of the marker is "Mileage".

The marker label for y is determined by the string provided in the
argument \code{title_y}, i.e. if \code{title_y = "Probability in percent"} the y
label of the marker is "Probability".
}
\examples{
# Alloy T7987 dataset taken from Meeker and Escobar(1998, p. 131)
cycles   <- c(300, 300, 300, 300, 300, 291, 274, 271, 269, 257, 256, 227, 226,
              224, 213, 211, 205, 203, 197, 196, 190, 189, 188, 187, 184, 180,
              180, 177, 176, 173, 172, 171, 170, 170, 169, 168, 168, 162, 159,
              159, 159, 159, 152, 152, 149, 149, 144, 143, 141, 141, 140, 139,
              139, 136, 135, 133, 131, 129, 123, 121, 121, 118, 117, 117, 114,
              112, 108, 104, 99, 99, 96, 94)
state <- c(rep(0, 5), rep(1, 67))

df_john <- johnson_method(x = cycles, event = state)

# Example 1: Probability Plot Weibull:
plot_weibull <- plot_prob(x = df_john$characteristic,
                          y = df_john$prob,
                          event = df_john$status,
                          id = df_john$id,
                          distribution = "weibull",
                          title_main = "Weibull Analysis",
                          title_x = "Cycles",
                          title_y = "Probability of Failure in \%",
                          title_trace = "Failed Items")

# Example 2: Probability Plot Lognormal:
plot_lognormal <- plot_prob(x = df_john$characteristic,
                          y = df_john$prob,
                          event = df_john$status,
                          id = df_john$id,
                          distribution = "lognormal",
                          title_main = "Lognormal Analysis",
                          title_x = "Cycles",
                          title_y = "Probability of Failure in \%",
                          title_trace = "Failed Items")
}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
