% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_return.R
\name{to_return}
\alias{to_return}
\title{Expectation for what's returned from a stubbed request}
\usage{
to_return(.data, ..., .list = list())
}
\arguments{
\item{.data}{input. Anything that can be coerced to a \code{StubbedRequest} class
object}

\item{...}{Comma separated list of named variables. accepts the following:
\code{status}, \code{body}, \code{headers}. See Details for more.}

\item{.list}{named list, has to be one of 'status', 'body',
and/or 'headers'. An alternative to passing in via \code{...}. Don't pass the
same thing to both, e.g. don't pass 'status' to \code{...}, and also 'status' to
this parameter}
}
\value{
an object of class \code{StubbedRequest}, with print method describing
the stub
}
\description{
Set response status code, response body, and/or response headers
}
\details{
Values for status, body, and headers:
\itemize{
\item status: (numeric/integer) three digit status code
\item body: various, including character string, list, raw, numeric, etc
\item headers: (list) a named list
}

response headers are returned with all lowercase names and the values
are all of type character. if numeric/integer values are given
(e.g., \code{to_return(headers = list(a = 10))}), we'll coerce any
numeric/integer values to character.
}
\note{
see more examples in \code{\link[=stub_request]{stub_request()}}
}
\examples{
# first, make a stub object
(req <- stub_request("post", "https://httpbin.org/post"))

# add status, body and/or headers
to_return(req, status = 200)
to_return(req, body = "stuff")
to_return(req, body = list(a = list(b = "world")))
to_return(req, headers = list(a = 5))
to_return(req, status = 200, body = "stuff", headers = list(a = 5))

# .list - pass in a named list instead
to_return(req, .list = list(body = list(foo = "bar")))
}
