% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{vpr_ctdroi_merge}
\alias{vpr_ctdroi_merge}
\title{Merge CTD and ROI data from VPR}
\usage{
vpr_ctdroi_merge(ctd_dat_combine, roi_dat_combine)
}
\arguments{
\item{ctd_dat_combine}{a CTD dataframe from VPR processing from \code{\link{vpr_ctd_read}}}

\item{roi_dat_combine}{a data frame of roi aid data from \code{\link{vpr_autoid_read}}}
}
\description{
Combines CTD data (time, hydrographic parameters), with ROI information
(identification number) into single dataframe, aligning ROI identification
numbers and taxa classifications with time and hydrographic parameters
}
\examples{
data('ctd_dat_combine')
data('roi_dat_combine')

ctd_roi_merge <- vpr_ctdroi_merge(ctd_dat_combine, roi_dat_combine)
}
\author{
E. Chisholm & K. Sorochan
}
