% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide.R
\name{slider}
\alias{slider}
\alias{pslider}
\title{Splits the input to a list according to the rolling window size.}
\usage{
slider(.x, .size = 1, .fill = NA, .partial = FALSE)

pslider(..., .size = 1, .fill = NA, .partial = FALSE)
}
\arguments{
\item{.x}{An object to slide over.}

\item{.size}{An integer for window size. If positive, moving forward from left
to right; if negative, moving backward (from right to left).}

\item{.fill}{A single value or data frame to replace \code{NA}.}

\item{.partial}{if \code{TRUE}, split to partial set (\code{FALSE} ignores specified
\code{.fill}).}

\item{...}{Multiple objects to be split in parallel.}

\item{x}{An objects to be split.}
}
\description{
Splits the input to a list according to the rolling window size.
}
\examples{
.x <- 1:5
.y <- 6:10
.z <- 11:15
.lst <- list(x = .x, y = .y, z = .z)
.df <- as.data.frame(.lst)

slider(.x, .size = 2)
slider(.lst, .size = 2)
pslider(list(.x, .y), list(.y))
slider(.df, .size = 2)
pslider(.df, .df, .size = 2)
}
