% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr-verbs.R
\name{nest.tbl_ts}
\alias{nest.tbl_ts}
\title{Nest repeated values in a list-variable.}
\usage{
\method{nest}{tbl_ts}(data, ..., .key = "data")
}
\arguments{
\item{data}{A \code{tbl_ts}.}

\item{...}{A selection of columns. If empty, all variables are
selected. You can supply bare variable names, select all
variables between x and z with \code{x:z}, exclude y with \code{-y}. For
more options, see the \code{\link[dplyr:select]{dplyr::select()}} documentation. See also
the section on selection rules below.}

\item{.key}{The name of the new column, as a string or symbol.

This argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:quo_name]{rlang::quo_name()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}
}
\value{
A tibble containing a list column of \code{tbl_ts}.
}
\description{
Nest repeated values in a list-variable.
}
\examples{
pedestrian \%>\% 
  nest(-Sensor)
pedestrian \%>\% 
  group_by(Sensor) \%>\% 
  nest()
}
\seealso{
\link[tidyr:nest]{tidyr::nest}, \link{unnest.lst_ts} for the inverse operation.
}
