% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtraj.R
\name{ggtraj}
\alias{ggtraj}
\title{ggplot Trajectory}
\usage{
ggtraj(traj_data, treatment, time, identifier, class, FUN = mean, ...)
}
\arguments{
\item{traj_data}{Merged datasets containing observed data in long format and trajectory groups.}

\item{treatment}{Name of the time-varying treatment.}

\item{time}{Name of the time variable.}

\item{identifier}{Name of the identifier variable.}

\item{class}{Name of the trajectory groups.}

\item{FUN}{Specify which statistics to display, by default calculate the mean.}

\item{\dots}{Additional arguments to be passed to ggplot functions.}
}
\value{
A ggplot object representing the trajectory groups using the observed treatment.
}
\description{
Use \code{"ggplot2"} to plot trajectory groups produced by the function \code{"build_traj"} using the observed treatment.
}
\examples{
\donttest{
obsdata_long = gendata(n = 1000, format = "long", total_followup = 12, seed = 945)
restraj = build_traj(obsdata = obsdata_long, number_traj = 3,
formula = as.formula(cbind(statins, 1 - statins) ~ time), identifier = "id")
datapost = restraj$data_post
head(datapost)
traj_data_long <- merge(obsdata_long, datapost, by = "id")
    AggFormula <- as.formula(paste("statins", "~", "time", "+", "class"))
    Aggtraj_data <- aggregate(AggFormula, data = traj_data_long, FUN = mean)
    Aggtraj_data
#Aggtraj_data with labels
traj_data_long[ , "traj_group"] <- factor(ifelse(traj_data_long[ , "class"] == "3" ,"Group1" ,
ifelse (traj_data_long[ , "class"]== "1" , "Group2" ,"Group3")))
AggFormula <- as.formula(paste("statins", "~", "time", "+", "traj_group"))
Aggtraj_data <- aggregate(AggFormula, data = traj_data_long, FUN = mean)
ggtraj(traj_data =  Aggtraj_data,
treatment = "statins",time= "time",identifier="id",class = "traj_group", FUN = mean)
}
}
