% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops-boxes.R
\name{nms}
\alias{nms}
\title{Non-maximum Suppression (NMS)}
\usage{
nms(boxes, scores, iou_threshold)
}
\arguments{
\item{boxes}{(Tensor[N, 4])): boxes to perform NMS on. They are
expected to be in \eqn{(x_{min}, y_{min}, x_{max}, y_{max})} format with
\itemize{
\item \eqn{0 \leq x_{min} < x_{max}} and
\item \eqn{0 \leq y_{min} < y_{max}}.
}}

\item{scores}{(Tensor[N]): scores for each one of the boxes}

\item{iou_threshold}{(float): discards all overlapping boxes with IoU > iou_threshold}
}
\value{
keep (Tensor): int64 tensor with the indices of the elements that
have been kept by NMS, sorted in decreasing order of scores.
}
\description{
Performs non-maximum suppression  (NMS) on the boxes according
to their intersection-over-union  (IoU). NMS iteratively removes
lower scoring boxes which have an IoU greater than iou_threshold
with another (higher scoring) box.
}
\details{
If multiple boxes have the exact same score and satisfy the IoU
criterion with respect to a reference box, the selected box is
not guaranteed to be the same between CPU and GPU. This is similar
to the behavior of argsort in torch when repeated values are present.

Current algorithm has a time complexity of O(n^2) and runs in native R.
It may be improve in the future by a Rcpp implementation or through alternative algorithm
}
