% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-flatten.R
\name{nn_flatten}
\alias{nn_flatten}
\title{Flattens a contiguous range of dims into a tensor.}
\usage{
nn_flatten(start_dim = 2, end_dim = -1)
}
\arguments{
\item{start_dim}{first dim to flatten (default = 2).}

\item{end_dim}{last dim to flatten (default = -1).}
}
\description{
For use with \link{nn_sequential}.
}
\section{Shape}{

\itemize{
\item Input: \verb{(*, S_start,..., S_i, ..., S_end, *)},
where \code{S_i} is the size at dimension \code{i} and \code{*} means any
number of dimensions including none.
\item Output: \verb{(*, S_start*...*S_i*...S_end, *)}.
}
}

\examples{
if (torch_is_installed()) {
input <- torch_randn(32, 1, 5, 5)
m <- nn_flatten()
m(input)
}
}
\seealso{
\link{nn_unflatten}
}
