% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviation_mean_squares.R
\name{deviation_mean_squares}
\alias{deviation_mean_squares}
\title{Deviation mean squares}
\usage{
deviation_mean_squares(
  data,
  trait,
  genotype,
  environment,
  unit.correct = FALSE
)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analysized.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties}

\item{environment}{colname of a column containing a character or factor vector labeling different environments}

\item{unit.correct}{logical, default is \code{FALSE}, returning the stability index with unit equals to squared unit of trait; when \code{TRUE}, returning stability index with the unit as same as unit of trait.}
}
\value{
a data table with deviation mean squares
}
\description{
\code{deviation_mean_squares} calculate variance of a genotype across environments.
}
\details{
Deviation mean squares (Eberhart and Russell, 1966) is calculatd based on regression function.
Variety with low stability variance is considered as stable.
Equation of deviation mean squares can be found in vignette file.
}
\examples{
data(Data)
deviation.mean.squares <- deviation_mean_squares(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment",
 unit.correct = FALSE)
}
\references{
\insertRef{eberhart1966}{toolStability}
}
\author{
Tien Cheng Wang
}
\keyword{approach}
\keyword{regression}
