% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/print_summ_str.R
\name{tind-methods}
\alias{tind-methods}
\alias{[.tind}
\alias{[<-.tind}
\alias{[[.tind}
\alias{[[<-.tind}
\alias{length<-.tind}
\alias{rep.tind}
\alias{c.tind}
\alias{unique.tind}
\alias{print.tind}
\alias{summary.tind}
\title{Basic Methods for \code{tind} Class}
\usage{
\method{[}{tind}(x, i)

\method{[}{tind}(x, i) <- value

\method{[[}{tind}(x, i)

\method{[[}{tind}(x, i) <- value

\method{length}{tind}(x) <- value

\method{rep}{tind}(x, ...)

\method{c}{tind}(...)

\method{unique}{tind}(x, ...)

\method{print}{tind}(x, ...)

\method{summary}{tind}(object, ...)
}
\arguments{
\item{x}{an object of \code{tind} class.}

\item{i}{an integer vector of indices or a logical vector indicating selection.}

\item{value}{replacement value.}

\item{...}{objects of \code{tind} class (for \code{c}, \code{min}, \code{max},
and \code{range}) or additional arguments passed to or from methods.}

\item{object}{an object of \code{tind} class.}
}
\value{
In general, methods return objects of \code{tind} class.

\code{print} returns its argument invisibly and is used for its side effect.

\code{summary} returns an object of class \code{c("summaryDefault", "table")}.
}
\description{
\code{tind} class supports all standard methods for vectors and
and vector-based classes like \code{Date} or \code{POSIXct}.
}
\details{
\code{tind} class supports standard indexing via \code{[]} and \code{[[]]}
operators, as well as replacement, In replacement, it is expected that the
right hand side is of the same type as the indexed object.

\code{length}, \code{length<-}, and \code{rep} methods work in a standard way.

\code{rev}, \code{head}, \code{tail}, as they are implemented using \code{[]}
operator, are also available for objects of \code{tind} class.

Concatenation method (\code{c}) works in a standard way. It is expected that
all arguments are of the same type. Arguments that are not of \code{tind} class
are converted.

\code{min}, \code{max}, and \code{range} work in a standard way. If the results
are not proper time indices (for example maximum over a vector of length 0),
\code{NA}s are returned.

\code{unique}, \code{duplicated}, \code{order}, \code{sort}, etc.
work in a standard way.

\code{print} prints time indices on the console and invisibly returns its
argument.

\code{summary} method returns summary information about time indices.
}
\examples{
# test sample
(dd <- as.tind(20210131) + sample((0:9), 15, replace = TRUE))
# indexing
dd[1]
dd[[1]]
dd[[1]] <- dd[[1]] + 1
dd
dd[2:3] <- dd[2:3] + 1
dd
# this will generate an error
try(
dd[10] <- now()
)
# length, length<-
length(dd)
length(dd) <- 7
dd
# rep, head, tail, rev
rep(dd, 2)
head(dd, 3)
tail(dd, -5)
rev(dd)
# min, max, range
min(dd)
max(dd)
range(dd)
# unique, duplicated
unique(dd)
duplicated(dd)
# order, sort
order(dd)
sort(dd)
# concatenation
c(dd, rev(dd))
# attempt at concatenating different types will result in an error
try(
c(today(), now())
)


}
\seealso{
\code{\link{format}} for formatting time indices,
\link{Ops} for operations on time indices.
}
