% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_tajimas_d.R
\name{pop_tajimas_d}
\alias{pop_tajimas_d}
\alias{pop_tajimas_d.tbl_df}
\alias{pop_tajimas_d.vctrs_bigSNP}
\alias{pop_tajimas_d.grouped_df}
\title{Estimate Tajima's D for the whole genome}
\usage{
pop_tajimas_d(.x, n_cores, block_size, ...)

\method{pop_tajimas_d}{tbl_df}(
  .x,
  n_cores = bigstatsr::nb_cores(),
  block_size = bigstatsr::block_size(nrow(.x), 1),
  ...
)

\method{pop_tajimas_d}{vctrs_bigSNP}(
  .x,
  n_cores = bigstatsr::nb_cores(),
  block_size = bigstatsr::block_size(length(.x), 1),
  ...
)

\method{pop_tajimas_d}{grouped_df}(
  .x,
  n_cores = bigstatsr::nb_cores(),
  block_size = bigstatsr::block_size(nrow(.x), 1),
  ...
)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotypes} column of
a \code{\link{gen_tibble}} object), or a \code{\link{gen_tibble}}.}

\item{n_cores}{number of cores to be used, it defaults to
\code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}}

\item{block_size}{maximum number of loci read at once.}

\item{...}{other arguments passed to specific methods, currently unused.}
}
\value{
A single numeric value (Tajima's D D) for the whole data set, \code{NA}
when the statistic is not defined. For grouped data a list of Tajima's D D
values (one per group) is returned.
}
\description{
Note that Tajima's D estimates from data that have been filtered or
ascertained can be difficult to interpret. This function should ideally
be used on sequence data prior to filtering.
}
\examples{
\dontshow{if (all(rlang::is_installed(c("RhpcBLASctl", "data.table")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
example_gt <- load_example_gt("grouped_gen_tbl")

# Compute Tajima's D
example_gt \%>\% pop_tajimas_d()
\dontshow{\}) # examplesIf}
}
