% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loci_ld_clump.R
\name{loci_ld_clump}
\alias{loci_ld_clump}
\alias{loci_ld_clump.tbl_df}
\alias{loci_ld_clump.vctrs_bigSNP}
\title{Clump loci based on a Linkage Disequilibrium threshold}
\usage{
loci_ld_clump(.x, .col = "genotypes", ...)

\method{loci_ld_clump}{tbl_df}(.x, .col = "genotypes", ...)

\method{loci_ld_clump}{vctrs_bigSNP}(
  .x,
  .col = "genotypes",
  S = NULL,
  thr_r2 = 0.2,
  size = 100/thr_r2,
  exclude = NULL,
  use_positions = TRUE,
  n_cores = 1,
  return_id = FALSE,
  ...
)
}
\arguments{
\item{.x}{a \code{\link{gen_tibble}} object}

\item{.col}{the column to be used when a tibble (or grouped tibble is passed
directly to the function). This defaults to "genotypes" and can only take
that value. There is no need for the user to set it, but it is included to
resolve certain tidyselect operations.}

\item{...}{currently not used.}

\item{S}{A vector of loci statistics which express the importance of each SNP
(the more important is the SNP, the greater should be the corresponding
statistic).\cr For example, if \code{S} follows the standard normal
distribution, and "important" means significantly different from 0, you
must use \code{abs(S)} instead.\cr
\strong{If not specified, MAFs are computed and used.}}

\item{thr_r2}{Threshold over the squared correlation between two SNPs.
Default is \code{0.2}.}

\item{size}{For one SNP, window size around this SNP to compute correlations.
Default is \code{100 / thr.r2} for clumping (0.2 -> 500; 0.1 -> 1000; 0.5 ->
200). If \code{use_positions = FALSE}, this is a window in number of SNPs,
otherwise it is a window in kb (genetic distance). Ideally, use positions,
as they provide a more sensible approach.}

\item{exclude}{Vector of SNP indices to exclude anyway. For example, can be
used to exclude long-range LD regions (see Price2008). Another use can be
for thresholding with respect to p-values associated with \code{S}.}

\item{use_positions}{boolean, if TRUE (the default), \code{size} is in kb, if
FALSE size is the number of SNPs.}

\item{n_cores}{number of cores to be used}

\item{return_id}{boolean on whether the id of SNPs to keep should be
returned. It defaults to FALSE, which returns a vector of booleans (TRUE or
FALSE)}
}
\value{
a boolean vector indicating whether the SNP should be kept (if
'return_id = FALSE', the default), else a vector of SNP indices to be kept
(if 'return_id = TRUE')
}
\description{
This function uses clumping to remove SNPs at high LD. When used with its
default options, clumping based on MAF is similar to standard pruning (as
done by PLINK with "--indep-pairwise (size+1) 1 thr.r2", but it results in a
better spread of SNPs over the chromosome.
}
\details{
Any missing values in the genotypes of a \code{gen_tibble} passed to
\code{loci_ld_clump} will cause an error. To deal with missingness, see
\code{\link[=gt_impute_simple]{gt_impute_simple()}}.
}
\examples{
\dontshow{if (all(rlang::is_installed(c("RhpcBLASctl", "data.table")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
example_gt <- load_example_gt("gen_tbl") \%>\% gt_impute_simple()

# To return a boolean vector indicating whether the SNP should be kept
example_gt \%>\% loci_ld_clump()
# To return a vector of SNP indices to be kept
example_gt \%>\% loci_ld_clump(return_id = TRUE)
\dontshow{\}) # examplesIf}
}
