% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-mixture_densities.R
\name{plot_density}
\alias{plot_density}
\title{Create density plots for mixture models}
\usage{
plot_density(x, variables = NULL, bw = FALSE, conditional = FALSE,
  alpha = 0.2, facet_labels = NULL)
}
\arguments{
\item{x}{Object to plot.}

\item{variables}{Which variables to plot. If NULL, plots all variables that
are present in all Mplus models.}

\item{bw}{Logical. Whether to make a black and white plot (for print) or a
color plot. Defaults to FALSE, because these density plots are hard to read
in black and white.}

\item{conditional}{Logical. Whether to show a conditional density plot
(surface area is divided amongst the latent classes), or a classic density
plot (surface area of the total density plot is equal to one, and is
subdivided amongst the classes).}

\item{alpha}{Numeric (0-1). Only used when bw and conditional are FALSE. Sets
the transparency of geom_density, so that classes with a small number of
cases remain visible.}

\item{facet_labels}{Named character vector, the names of which should
correspond to the facet labels one wishes to rename, and the values of which
provide new names for these facets. For example, to rename variables, in the
example with the 'iris' data below, one could specify:
\code{facet_labels = c("Pet_leng" = "Petal length")}.}
}
\value{
An object of class 'ggplot'.
}
\description{
Creates a faceted plot of density plots for an object of class 'tidyLPA'. For
each variable, a Total density plot will be shown, along with separate
density plots for each latent class, where cases are weighted by the
posterior probability of being assigned to that class.
}
\examples{
\dontrun{
results <- iris \%>\%
  subset(select = c("Sepal.Length", "Sepal.Width",
    "Petal.Length", "Petal.Width")) \%>\%
  estimate_profiles(1:3)
}
\dontrun{
plot_density(results, variables = "Petal.Length")
}
\dontrun{
plot_density(results, bw = TRUE)
}
\dontrun{
plot_density(results, bw = FALSE, conditional = TRUE)
}
\dontrun{
plot_density(results[[2]], variables = "Petal.Length")
}
}
\author{
Caspar J. van Lissa
}
\keyword{density}
\keyword{mixture}
\keyword{plot}
