% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{pi.weights}
\alias{pi.weights}
\alias{pi.weights.um}
\title{Pi weights of an AR(I)MA model}
\usage{
pi.weights(um, ...)

\method{pi.weights}{um}(um, lag.max = 10, var.pi = FALSE, ...)
}
\arguments{
\item{um}{an object of class \code{um}.}

\item{...}{additional arguments.}

\item{lag.max}{largest AR(Inf) coefficient required.}

\item{var.pi}{logical. If TRUE (FALSE), the I polynomials is 
considered (ignored).}
}
\value{
A numeric vector.
}
\description{
\code{pi.weights} computes the pi-weights of an AR(I)MA model.
}
\examples{
um1 <- um(i = "(1 - B)(1 - B^12)", ma = "(1 - 0.8B)(1 - 0.8B^12)")
pi.weights(um1, var.pi = TRUE)

}
