% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-inheritance.R
\name{inheritance-expectations}
\alias{inheritance-expectations}
\alias{expect_type}
\alias{expect_s3_class}
\alias{expect_s4_class}
\alias{expect_r6_class}
\alias{expect_s7_class}
\title{Do you expect an S3/S4/R6/S7 object that inherits from this class?}
\usage{
expect_type(object, type)

expect_s3_class(object, class, exact = FALSE)

expect_s4_class(object, class)

expect_r6_class(object, class)

expect_s7_class(object, class)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{type}{String giving base type (as returned by \code{\link[=typeof]{typeof()}}).}

\item{class}{The required type varies depending on the function:
\itemize{
\item \code{expect_type()}: a string.
\item \code{expect_s3_class()}: a string or character vector. The behaviour of
multiple values (i.e. a character vector) is controlled by the
\code{exact} argument.
\item \code{expect_s4_class()}: a string.
\item \code{expect_r6_class()}: a string.
\item \code{expect_s7_class()}: an \code{\link[S7:S7_class]{S7::S7_class()}} object.
}

For historical reasons, \code{expect_s3_class()} and \code{expect_s4_class()} also
take \code{NA} to assert that the \code{object} is not an S3 or S4 object.}

\item{exact}{If \code{FALSE}, the default, checks that \code{object} inherits
from any element of \code{class}. If \code{TRUE}, checks that object has a class
that exactly matches \code{class}.}
}
\description{
See \url{https://adv-r.hadley.nz/oo.html} for an overview of R's OO systems, and
the vocabulary used here.
\itemize{
\item \code{expect_type(x, type)} checks that \code{typeof(x)} is \code{type}.
\item \code{expect_s3_class(x, class)} checks that \code{x} is an S3 object that
\code{\link[=inherits]{inherits()}} from \code{class}
\item \code{expect_s3_class(x, NA)} checks that \code{x} isn't an S3 object.
\item \code{expect_s4_class(x, class)} checks that \code{x} is an S4 object that
\code{\link[=is]{is()}} \code{class}.
\item \code{expect_s4_class(x, NA)} checks that \code{x} isn't an S4 object.
\item \code{expect_r6_class(x, class)} checks that \code{x} an R6 object that
inherits from \code{class}.
\item \code{expect_s7_class(x, Class)} checks that \code{x} is an S7 object that
\code{\link[S7:S7_inherits]{S7::S7_inherits()}} from \code{Class}
}

See \code{\link[=expect_vector]{expect_vector()}} for testing properties of objects created by vctrs.
}
\examples{
x <- data.frame(x = 1:10, y = "x", stringsAsFactors = TRUE)
# A data frame is an S3 object with class data.frame
expect_s3_class(x, "data.frame")
show_failure(expect_s4_class(x, "data.frame"))
# A data frame is built from a list:
expect_type(x, "list")

f <- factor(c("a", "b", "c"))
o <- ordered(f)

# Using multiple class names tests if the object inherits from any of them
expect_s3_class(f, c("ordered", "factor"))
# Use exact = TRUE to test for exact match
show_failure(expect_s3_class(f, c("ordered", "factor"), exact = TRUE))
expect_s3_class(o, c("ordered", "factor"), exact = TRUE)

# An integer vector is an atomic vector of type "integer"
expect_type(x$x, "integer")
# It is not an S3 object
show_failure(expect_s3_class(x$x, "integer"))

# Above, we requested data.frame() converts strings to factors:
show_failure(expect_type(x$y, "character"))
expect_s3_class(x$y, "factor")
expect_type(x$y, "integer")
}
\seealso{
Other expectations: 
\code{\link{comparison-expectations}},
\code{\link{equality-expectations}},
\code{\link{expect_error}()},
\code{\link{expect_length}()},
\code{\link{expect_match}()},
\code{\link{expect_named}()},
\code{\link{expect_null}()},
\code{\link{expect_output}()},
\code{\link{expect_reference}()},
\code{\link{expect_silent}()},
\code{\link{logical-expectations}}
}
\concept{expectations}
