% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_targets.R
\name{use_targets}
\alias{use_targets}
\title{Use targets}
\usage{
use_targets(
  script = targets::tar_config_get("script"),
  open = interactive(),
  overwrite = FALSE,
  scheduler = NULL,
  job_name = NULL
)
}
\arguments{
\item{script}{Character of length 1, where to write
the target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}.}

\item{open}{Logical of length 1, whether to open the file for editing
in the RStudio IDE.}

\item{overwrite}{Logical of length 1, \code{TRUE} to overwrite the the target
script file, \code{FALSE} otherwise.}

\item{scheduler}{Deprecated in \code{targets} version 1.5.0.9001 (2024-02-12).}

\item{job_name}{Deprecated in \code{targets} version 1.5.0.9001 (2024-02-12).}
}
\value{
\code{NULL} (invisibly).
}
\description{
Set up \code{targets} for an existing project.
}
\details{
\code{use_targets()} writes an example \verb{_targets.R} script to
get started with a \code{targets} pipeline for the current project.
Follow the comments in this script to adapt it as needed.
For more information, please visit
\url{https://books.ropensci.org/targets/walkthrough.html}.
}
\examples{
if (identical(Sys.getenv("TAR_INTERACTIVE_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
use_targets(open = FALSE)
})
}
}
\seealso{
Other help: 
\code{\link{tar_reprex}()},
\code{\link{targets-package}},
\code{\link{use_targets_rmd}()}
}
\concept{help}
