% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{ibs_survmat}
\alias{ibs_survmat}
\title{Integrated Brier Score (IBS) from a Survival Probability Matrix}
\usage{
ibs_survmat(object, sp_matrix, times)
}
\arguments{
\item{object}{A `Surv` object with observed time and status.}

\item{sp_matrix}{A data frame or matrix of predicted survival probabilities.
Each column corresponds to a time point in `times`.}

\item{times}{A numeric vector of time points. Must match the columns of `sp_matrix`.}
}
\value{
A single numeric value representing the integrated Brier score.
}
\description{
Computes the Integrated Brier Score (IBS) over a set of evaluation time points,
using trapezoidal integration and IPCW adjustment for right-censoring.
}
\examples{
set.seed(123)
library(survival)
data(veteran, package = "survival")
idx <- sample(nrow(veteran), 0.7 * nrow(veteran))
train <- veteran[idx, ]; test <- veteran[-idx, ]
mod <- survdnn(Surv(time, status) ~
age + karno + celltype, data = train, epochs = 50, verbose = FALSE)
pred <- predict(mod, newdata = test, times = c(30, 90, 180), type = "survival")
y_test <- model.response(model.frame(mod$formula, test))
ibs_survmat(y_test, sp_matrix = pred, times = c(30, 90, 180))
}
