% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startswith.R
\name{startsWith}
\alias{startsWith}
\alias{endsWith}
\title{Detect Pattern Occurrences at Start or End of Strings}
\usage{
startsWith(
  x,
  pattern = prefix,
  ...,
  ignore_case = ignore.case,
  fixed = TRUE,
  ignore.case = FALSE,
  prefix
)

endsWith(
  x,
  pattern = suffix,
  ...,
  ignore_case = ignore.case,
  fixed = TRUE,
  ignore.case = FALSE,
  suffix
)
}
\arguments{
\item{x}{character vector whose elements are to be examined}

\item{pattern}{character vector with patterns to search for}

\item{...}{further arguments to \code{\link[stringi]{stri_startswith}}
and \code{\link[stringi]{stri_endswith}}, e.g., \code{locale}}

\item{ignore_case}{single logical value; indicates whether matching
should be case-insensitive}

\item{fixed}{single logical value;
\code{TRUE} for fixed pattern matching
    (see \link[stringi]{about_search_fixed});
\code{NA} for the Unicode collation algorithm
    (\link[stringi]{about_search_coll});
\code{FALSE} is not supported -- use \code{\link{grepl}} instead}

\item{ignore.case}{alias to the \code{ignore_case} argument [DEPRECATED]}

\item{prefix, suffix}{aliases to the \code{pattern} argument [DEPRECATED]}
}
\value{
Each function returns a logical vector, indicating whether a pattern
match has been detected or not.
They preserve the attributes of the longest inputs (unless they are
dropped due to coercion).
}
\description{
Determines if a string starts or ends with a match to a specified
fixed pattern.
}
\details{
These functions are fully vectorised with respect to both arguments.

For matching with regular expressions, see \code{\link{grepl}}
with patterns like \code{"^prefix"} and \code{"suffix$"}.
}
\section{Differences from Base R}{

Replacements for base \code{\link[base]{startsWith}}
and \code{\link[base]{endsWith}}
implemented with \code{\link[stringi]{stri_startswith}}
and \code{\link[stringi]{stri_endswith}}.

\itemize{
\item there are inconsistencies between the argument order and naming
    in \code{\link[base]{grepl}}, \code{\link[base]{strsplit}},
    and \code{\link[base]{startsWith}} (amongst others); e.g.,
    where the needle can precede the haystack, the use of the forward
    pipe operator, \code{\link[base]{|>}}, is less convenient
    \bold{[fixed here]}
\item \code{\link[base]{grepl}} also features the \code{ignore.case} argument
    \bold{[added here]}
\item partial recycling without the usual warning
    \bold{[fixed here]}
\item no attributes preserved whatsoever
    \bold{[fixed here]}
\item not suitable for natural language processing
    \bold{[fixed here -- use \code{fixed=NA}]}
}
}

\examples{
startsWith("ababa", c("a", "ab", "aba", "baba", NA))
outer(
    c("aba", "abb", "abc", "baba", "bac"),
    c("A", "B", "C"),
    endsWith,
    ignore_case=TRUE
)
x <- c("Mario", "mario", "M\u00E1rio", "M\u00C1RIO", "Mar\u00EDa", "Rosario")
x[startsWith(x, "mario", ignore_case=TRUE)]
x[startsWith(x, "mario", fixed=NA, strength=1L)]

}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{grepl}}, \code{\link{substr}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
