% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_ranef.R
\name{show_ranef}
\alias{show_ranef}
\title{Get a caterpillar plot of random effects from a mixed model}
\usage{
show_ranef(model, group, reorder = TRUE)
}
\arguments{
\item{model}{a fitted mixed model with random intercepts}

\item{group}{What random intercept/slopes do you want to see as a caterpillar plot? Declare it as a character}

\item{reorder}{optional argument. DEFAULT is TRUE, which ``re-orders'' the intercepts by the
original value in the data. If FALSE, the ensuing caterpillar plot defaults to a default method of ordering
the levels of the random effect by their estimated conditional mode.}
}
\value{
\code{show_ranef()} returns a caterpillar plot of the random intercepts from a given
mixed model. If \code{broom.mixed::augment()} can process it, this function should work just fine.
}
\description{
\code{show_ranef()} allows a user estimating a mixed model to quickly
plot the random intercepts (with conditional variances) of a given random effect
in a mixed model. In cases where there is a random slope over the intercept, the function
plots the random slope as another caterpillar plot (as another facet)
}
\details{
This function is a simple wrapper in which \code{broom.mixed} and, obviously
\code{ggplot2} are doing the heavy lifting.
}
\examples{

library(lme4)
library(stevemisc)
data(sleepstudy)

M1 <- lmer(Reaction ~ Days + (Days | Subject), data=sleepstudy)
show_ranef(M1, "Subject")
show_ranef(M1, "Subject", reorder=FALSE)

}
\author{
Steven V. Miller
}
