% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_scale.R
\name{make_scale}
\alias{make_scale}
\title{Rescale Vector to Arbitrary Minimum and Maximum}
\usage{
make_scale(x, minim, maxim)
}
\arguments{
\item{x}{a numeric vector}

\item{minim}{a desired numeric minimum}

\item{maxim}{a desired numeric maximum}
}
\value{
The function takes a numeric vector and returns a rescaled version of it with the observed (desired) minimum, the observed (desired)
maximum, and rescaled values between both extremes.
}
\description{
\code{make_scale()} will rescale any vector to have a user-defined minimum and maximum.
}
\details{
This function is useful if you wanted to do some kind of minimum-maximum rescaling of a variable
on some given scale, prominently rescaling to a minimum of 0 and a maximum of 1 (thinking ahead to a regression).
The function is flexible enough for any minimum or maximum.
}
\examples{

x <- runif(100, 1, 100)
make_scale(x, 2, 5) # works
make_scale(x, 5, 2) # results in message
make_scale(x, 0, 1) # probably why you're using this.
}
