% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{profile_rotation}
\alias{profile_rotation}
\title{Test rotation invariance of index functions for selected 2-d data set.}
\usage{
profile_rotation(d, index_list, index_labels, n = 200)
}
\arguments{
\item{d}{data (2 column matrix containing distribution to be rotated)}

\item{index_list}{list of index functions to calculate for each entry}

\item{index_labels}{labels used in the output}

\item{n}{number of steps in the rotation (default = 200)}
}
\value{
index values for each rotation step
}
\description{
Ideally a projection pursuit index should be roation invariant, we
test this explicitly by profiling the index while rotating a
distribution.
}
\examples{
d <- as.matrix(sin_data(30, 2))
index_list <- list(tourr::holes(), scag_index("stringy"), mine_indexE("MIC"))
index_labels <- c("holes", "stringy", "mic")
pRot <- profile_rotation(d, index_list, index_labels, n = 50)
plot_rotation(pRot)
}
