% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{craters}
\alias{craters}
\title{Craters named by the IUA}
\format{
A data frame with 5235 rows and 7 variables:
\describe{
  \item{ID}{database ID.}
  \item{name}{name of the crater.}
  \item{target}{name of the celestial body. A factor with 43 levels,
  such as \code{"Moon"}, \code{"Venus"}, or \code{"Europa"}.}
  \item{target_type}{type of celestial body. A factor with 3 levels:
  \code{"Planet"}, \code{"Moon"}, \code{"Dwarf planet"}, or
  \code{"Asteroid"}.}
  \item{diameter}{diameter of the crater (in km).}
  \item{theta}{longitude angle \eqn{\theta \in [0, 2\pi)} of the
  crater center.}
  \item{phi}{latitude angle \eqn{\phi \in [-\pi/2, \pi/2]} of the
  crater center.}
}
}
\source{
\url{https://planetarynames.wr.usgs.gov/AdvancedSearch}
}
\usage{
craters
}
\description{
\emph{Named} craters of the Solar System by the
\href{https://planetarynames.wr.usgs.gov}{Gazetteer of Planetary
Nomenclature} of the International Astronomical Union (IUA).
}
\details{
"Craters" are understood in the Gazetteer of Planetary Nomenclature as
roughly circular depressions resulting from impact or volcanic activity
(the geological origin is
\href{https://planetarynames.wr.usgs.gov/DescriptorTerms}{unspecified}).

Be aware that the dataset only contains \emph{named} craters by the IUA.
Therefore, there is likely a \bold{high uniform bias} on the distribution
of craters. Presumably the naming process attempts to cover the planet in
a somehow uniform fashion (distant craters are more likely to be named than
neighboring craters). Also, there are substantially more craters in the
listed bodies than those named by the IUA. See \code{\link{venus}} and
\code{\link{rhea}} for more detailed and specific crater datasets.

The \eqn{(\theta, \phi)} angles are such their associated planetocentric
coordinates are:
\deqn{(\cos(\phi) \cos(\theta), \cos(\phi) \sin(\theta), \sin(\phi))',}{
(cos(\phi) cos(\theta), cos(\phi) sin(\theta), sin(\phi))',}
with \eqn{(0, 0, 1)'} denoting the north pole.

The script performing the data preprocessing is available at
\href{https://github.com/egarpor/sphunif/blob/master/data-raw/craters.R}{
\code{craters.R}}. The data was retrieved on 2020-05-31.
}
\examples{
# Load data
data("craters")

# Add Cartesian coordinates
craters$X <- cbind(cos(craters$theta) * cos(craters$phi),
                   sin(craters$theta) * cos(craters$phi),
                   sin(craters$phi))

# Tests to be performed
type_tests <- c("PCvM", "PAD", "PRt")

# Tests for Venus and Rhea
unif_test(data = craters$X[craters$target == "Venus", ], type = type_tests,
          p_value = "asymp")
unif_test(data = craters$X[craters$target == "Rhea", ], type = type_tests,
          p_value = "asymp")
}
\keyword{datasets}
