% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark_ide.R
\name{spark_ide_connection_open}
\alias{spark_ide_connection_open}
\alias{spark_ide_connection_closed}
\alias{spark_ide_connection_updated}
\alias{spark_ide_connection_actions}
\alias{spark_ide_objects}
\alias{spark_ide_columns}
\alias{spark_ide_preview}
\title{Set of functions to provide integration with the RStudio IDE}
\usage{
spark_ide_connection_open(con, env, connect_call)

spark_ide_connection_closed(con)

spark_ide_connection_updated(con, hint)

spark_ide_connection_actions(con)

spark_ide_objects(con, catalog, schema, name, type)

spark_ide_columns(
  con,
  table = NULL,
  view = NULL,
  catalog = NULL,
  schema = NULL
)

spark_ide_preview(
  con,
  rowLimit,
  table = NULL,
  view = NULL,
  catalog = NULL,
  schema = NULL
)
}
\arguments{
\item{con}{Valid Spark connection}

\item{env}{R environment of the interactive R session}

\item{connect_call}{R code that can be used to re-connect to the Spark connection}

\item{hint}{Name of the Spark connection that the RStudio IDE can use as reference.}

\item{catalog}{Name of the top level of the requested table or view}

\item{schema}{Name of the second most top level of the requested level or view}

\item{name}{The new of the view or table being requested}

\item{type}{Type of the object being requested, 'view' or 'table'}

\item{table}{Name of the requested table}

\item{view}{Name of the requested view}

\item{rowLimit}{The number of rows to show in the 'Preview' pane of the RStudio
IDE}
}
\description{
Set of functions to provide integration with the RStudio IDE
}
\details{
These function are meant for downstream packages, that provide additional
backends to `sparklyr`, to override the opening, closing, update, and preview
functionality. The arguments are driven by what the RStudio IDE API expects them
to be, so this is the reason why some use `type` to designated views or tables,
and others have one argument for `table`, and another for `view`.
}
