/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichBoolean;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import sparklyr.Collectors$;
import sparklyr.Logger;
import sparklyr.Numeric;
import sparklyr.RawSXP;
import sparklyr.Serializer$;
import sparklyr.StructTypeAsJSON$;

public final class RUtils$ {
    public static RUtils$ MODULE$;
    private final char XDR_FORMAT;
    private final int CHARSXP;
    private final int LGLSXP;
    private final int INTSXP;
    private final int REALSXP;
    private final int STRSXP;
    private final int VECSXP;
    private final int RAWSXP;
    private final int NILVALUE_SXP;
    private final int NA_INTEGER;

    static {
        new RUtils$();
    }

    public void validateSerializationFormat(DataInputStream dis, boolean verbose) {
        block2: {
            char format = Serializer$.MODULE$.readObjectType(dis);
            dis.readByte();
            if (this.XDR_FORMAT != format) {
                throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported R serialization format '").append(format).append("'").toString());
            }
            int version = Serializer$.MODULE$.readInt(dis);
            int writerVersion = Serializer$.MODULE$.readInt(dis);
            int minReaderVersion = Serializer$.MODULE$.readInt(dis);
            if (version != 2) {
                throw new IllegalArgumentException(new StringBuilder(38).append("Unsupported R serialization version '").append(version).append("'").toString());
            }
            if (!verbose) break block2;
            Logger logger = new Logger("Utils", 0);
            logger.log(new StringBuilder(25).append("R serialization version: ").append(version).toString());
            logger.log(new StringBuilder(32).append("R serialization writer version: ").append(writerVersion).toString());
            logger.log(new StringBuilder(36).append("R serialization min reader version: ").append(minReaderVersion).toString());
        }
    }

    public boolean validateSerializationFormat$default$2() {
        return false;
    }

    public Object[] unserializeColumn(DataInputStream dis) {
        Logger logger = new Logger("RUtils", 0);
        int dtype = this.readDataType(dis);
        if (this.VECSXP != dtype) {
            logger.logWarning(new StringBuilder(28).append("Unexpected column data type ").append(dtype).toString());
        }
        long num_rows = this.readLength(dis);
        return (Object[])((TraversableOnce)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)num_rows)).map((Function1 & Serializable & scala.Serializable)r -> RUtils$.$anonfun$unserializeColumn$1(dis, logger, BoxesRunTime.unboxToLong((Object)r)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
    }

    private int[] unserializeIntColumn(DataInputStream dis) {
        return (int[])Array$.MODULE$.fill(5, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
    }

    private String[] unserializeStringColumn(DataInputStream dis) {
        return (String[])Array$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> "", ClassTag$.MODULE$.apply(String.class));
    }

    private int readDataType(DataInputStream dis) {
        return Serializer$.MODULE$.readInt(dis) & 0xFF;
    }

    private long readLength(DataInputStream dis) {
        int x = Serializer$.MODULE$.readInt(dis);
        if (-1 == x) {
            throw new IllegalArgumentException("Vector with length greater than INT_MAX (i.e., 'LONG_VECTOR') is not supported yet");
        }
        int len = x;
        if (len < 0) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Negative serialized vector length: ").append(len).toString());
        }
        return len;
    }

    private int extractInt(byte[] bytes, int offset) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> (Predef$.MODULE$.byte2Byte(bytes[offset + i]).intValue() & 0xFF) << 24 - i * 8, IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(p, q) -> p | q));
    }

    private int rVersion(int v, int p, int s) {
        return v * 65536 + p * 256 + s;
    }

    public void writeXdrHeader(DataOutputStream dos) {
        dos.writeByte(this.XDR_FORMAT);
        dos.writeByte(10);
        dos.writeInt(2);
        dos.writeInt(this.rVersion(1, 4, 0));
        dos.writeInt(this.rVersion(1, 4, 0));
    }

    public void writeDataFrameHeader(DataOutputStream dos, Seq<Tuple2<String, String>> dtypes) {
        this.writeFlags(dos, this.VECSXP, this.writeFlags$default$3(), this.writeFlags$default$4(), this.writeFlags$default$5(), this.writeFlags$default$6());
        this.writeLength(dos, 5);
        this.writeStringValues(dos, (Seq<String>)((Seq)dtypes.map((Function1 & Serializable & scala.Serializable)x -> (String)x._1(), Seq$.MODULE$.canBuildFrom())));
        ListBuffer timestampColIdxes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer dateColIdxes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer structColIdxes = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), dtypes.length()).map((Function1 & Serializable & scala.Serializable)idx -> RUtils$.$anonfun$writeDataFrameHeader$2(dtypes, timestampColIdxes, dateColIdxes, structColIdxes, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom());
        this.writeIntValues(dos, (Seq<Object>)timestampColIdxes);
        this.writeIntValues(dos, (Seq<Object>)dateColIdxes);
        this.writeIntValues(dos, (Seq<Object>)structColIdxes);
        this.writeFlags(dos, this.VECSXP, this.writeFlags$default$3(), this.writeFlags$default$4(), this.writeFlags$default$5(), this.writeFlags$default$6());
        this.writeLength(dos, dtypes.length());
    }

    public void writeColumn(DataOutputStream dos2, int numRows, Iterator<Row> colIter, String dtype) {
        Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> function3;
        String string = dtype;
        if ("BooleanType".equals(string)) {
            function3 = this.booleanColumnWriter();
        } else if ("ByteType".equals(string)) {
            function3 = this.integralColumnWriter((Integral)Numeric.ByteIsIntegral$.MODULE$);
        } else if ("ShortType".equals(string)) {
            function3 = this.integralColumnWriter((Integral)Numeric.ShortIsIntegral$.MODULE$);
        } else if ("IntegerType".equals(string)) {
            function3 = this.integralColumnWriter((Integral)Numeric.IntIsIntegral$.MODULE$);
        } else if ("FloatType".equals(string)) {
            function3 = this.numericColumnWriter((scala.math.Numeric)Numeric.FloatIsFractional$.MODULE$);
        } else if ("LongType".equals(string)) {
            function3 = this.numericColumnWriter((scala.math.Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else if ("DoubleType".equals(string)) {
            function3 = this.numericColumnWriter((scala.math.Numeric)Numeric.DoubleIsFractional$.MODULE$);
        } else {
            Option option = Collectors$.MODULE$.ReDecimalType().unapplySeq((CharSequence)string);
            if (!option.isEmpty()) {
                function3 = this.decimalColumnWriter();
            } else if ("StringType".equals(string)) {
                function3 = this.stringColumnWriter();
            } else if ("TimestampType".equals(string)) {
                function3 = this.timestampColumnWriter();
            } else if ("DateType".equals(string)) {
                function3 = this.dateColumnWriter();
            } else {
                Option option2 = Collectors$.MODULE$.ReBooleanArrayType().unapplySeq((CharSequence)string);
                if (!option2.isEmpty()) {
                    function3 = this.arrayColumnWriter(this.LGLSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                        RUtils$.MODULE$.writeLglValue(dos, v);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    Option option3 = Collectors$.MODULE$.ReByteArrayType().unapplySeq((CharSequence)string);
                    if (!option3.isEmpty()) {
                        function3 = this.rawColumnWriter();
                    } else {
                        Option option4 = Collectors$.MODULE$.ReShortArrayType().unapplySeq((CharSequence)string);
                        if (!option4.isEmpty()) {
                            function3 = this.arrayColumnWriter(this.INTSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                RUtils$.MODULE$.writeIntegralValue(dos, v, (Integral)Numeric.ShortIsIntegral$.MODULE$);
                                return BoxedUnit.UNIT;
                            });
                        } else {
                            Option option5 = Collectors$.MODULE$.ReIntegerArrayType().unapplySeq((CharSequence)string);
                            if (!option5.isEmpty()) {
                                function3 = this.arrayColumnWriter(this.INTSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                    RUtils$.MODULE$.writeIntegralValue(dos, v, (Integral)Numeric.IntIsIntegral$.MODULE$);
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                Option option6 = Collectors$.MODULE$.ReLongArrayType().unapplySeq((CharSequence)string);
                                if (!option6.isEmpty()) {
                                    function3 = this.arrayColumnWriter(this.REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                        RUtils$.MODULE$.writeNumericValue(dos, v, (scala.math.Numeric)Numeric.LongIsIntegral$.MODULE$);
                                        return BoxedUnit.UNIT;
                                    });
                                } else {
                                    Option option7 = Collectors$.MODULE$.ReDecimalArrayType().unapplySeq((CharSequence)string);
                                    if (!option7.isEmpty()) {
                                        function3 = this.arrayColumnWriter(this.REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                            RUtils$.MODULE$.writeDecimalValue(dos, v);
                                            return BoxedUnit.UNIT;
                                        });
                                    } else {
                                        Option option8 = Collectors$.MODULE$.ReFloatArrayType().unapplySeq((CharSequence)string);
                                        if (!option8.isEmpty()) {
                                            function3 = this.arrayColumnWriter(this.REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                                RUtils$.MODULE$.writeNumericValue(dos, v, (scala.math.Numeric)Numeric.FloatIsFractional$.MODULE$);
                                                return BoxedUnit.UNIT;
                                            });
                                        } else {
                                            Option option9 = Collectors$.MODULE$.ReDoubleArrayType().unapplySeq((CharSequence)string);
                                            if (!option9.isEmpty()) {
                                                function3 = this.arrayColumnWriter(this.REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                                    RUtils$.MODULE$.writeNumericValue(dos, v, (scala.math.Numeric)Numeric.DoubleIsFractional$.MODULE$);
                                                    return BoxedUnit.UNIT;
                                                });
                                            } else {
                                                Option option10 = Collectors$.MODULE$.ReStringArrayType().unapplySeq((CharSequence)string);
                                                if (!option10.isEmpty()) {
                                                    function3 = this.arrayColumnWriter(this.STRSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                                        RUtils$.MODULE$.writeStringValue(dos, v);
                                                        return BoxedUnit.UNIT;
                                                    });
                                                } else {
                                                    Option option11 = Collectors$.MODULE$.ReTimestampArrayType().unapplySeq((CharSequence)string);
                                                    if (!option11.isEmpty()) {
                                                        function3 = this.arrayColumnWriter(this.REALSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                                            RUtils$.MODULE$.writeTimestampValue(dos, v);
                                                            return BoxedUnit.UNIT;
                                                        });
                                                    } else {
                                                        Option option12 = Collectors$.MODULE$.ReDateArrayType().unapplySeq((CharSequence)string);
                                                        if (!option12.isEmpty()) {
                                                            function3 = this.arrayColumnWriter(this.INTSXP, (Function2<DataOutputStream, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(dos, v) -> {
                                                                RUtils$.MODULE$.writeDateValue(dos, v);
                                                                return BoxedUnit.UNIT;
                                                            });
                                                        } else {
                                                            String string2 = StructTypeAsJSON$.MODULE$.DType();
                                                            String string3 = string;
                                                            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                                                                function3 = this.stringColumnWriter();
                                                            } else {
                                                                throw new IllegalArgumentException(new StringBuilder(67).append("Serializing Spark dataframe column of type '").append(dtype).append("' to RDS is unsupported").toString());
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> writer = function3;
        writer.apply((Object)dos2, (Object)BoxesRunTime.boxToInteger((int)numRows), colIter);
    }

    private void writeDateValue(DataOutputStream dos, Object v) {
        Serializer$.MODULE$.writeDate(dos, Collectors$.MODULE$.extractDaysSinceEpoch(v));
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> booleanColumnWriter() {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$booleanColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeLglValue(DataOutputStream dos, Object v) {
        int n;
        if (v == null) {
            n = this.NA_INTEGER;
        } else {
            boolean b = BoxesRunTime.unboxToBoolean((Object)v);
            n = new RichBoolean(Predef$.MODULE$.booleanWrapper(b)).compare((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        dos.writeInt(n);
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> rawColumnWriter() {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$rawColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private <SrcType> Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> integralColumnWriter(Integral<SrcType> evidence$1) {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$integralColumnWriter$1(evidence$1, dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeIntValues(DataOutputStream dos, Seq<Object> vals) {
        this.writeFlags(dos, this.INTSXP, this.writeFlags$default$3(), this.writeFlags$default$4(), this.writeFlags$default$5(), this.writeFlags$default$6());
        this.writeLength(dos, vals.length());
        vals.map((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> MODULE$.writeIntegralValue(dos, BoxesRunTime.boxToInteger((int)x), (Integral)Numeric.IntIsIntegral$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    private <SrcType> void writeIntegralValue(DataOutputStream dos, Object v, Integral<SrcType> evidence$2) {
        dos.writeInt(v == null ? this.NA_INTEGER : ((scala.math.Numeric)Predef$.MODULE$.implicitly(evidence$2)).toInt(v));
    }

    private void writeRawValue(DataOutputStream dos, Object v) {
        this.writeFlags(dos, this.RAWSXP, this.writeFlags$default$3(), this.writeFlags$default$4(), this.writeFlags$default$5(), this.writeFlags$default$6());
        if (v == null) {
            this.writeLength(dos, -1);
        } else {
            Byte[] buf = (Byte[])((WrappedArray)v).array();
            this.writeLength(dos, buf.length);
            dos.write((byte[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])buf)).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToByte((byte)RUtils$.$anonfun$writeRawValue$1(x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
        }
    }

    private <SrcType> Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> numericColumnWriter(scala.math.Numeric<SrcType> evidence$3) {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$numericColumnWriter$1(evidence$3, dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private <SrcType> void writeNumericValue(DataOutputStream dos, Object v, scala.math.Numeric<SrcType> evidence$4) {
        Serializer$.MODULE$.writeNumeric(dos, new Numeric((Option<Object>)(v == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToDouble((double)((scala.math.Numeric)Predef$.MODULE$.implicitly(evidence$4)).toDouble(v))))));
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> decimalColumnWriter() {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$decimalColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeDecimalValue(DataOutputStream dos, Object v) {
        None$ none$;
        Object object = v;
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            none$ = new Some((Object)BoxesRunTime.boxToDouble((double)bigDecimal.doubleValue()));
        } else {
            none$ = None$.MODULE$;
        }
        Serializer$.MODULE$.writeNumeric(dos, new Numeric((Option<Object>)none$));
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> stringColumnWriter() {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$stringColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> timestampColumnWriter() {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$timestampColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeTimestampValue(DataOutputStream dos, Object v) {
        double d;
        Object object = v;
        if (object instanceof Date) {
            Date date = (Date)object;
            d = Serializer$.MODULE$.timestampToSeconds(date);
        } else {
            d = Double.NaN;
        }
        dos.writeDouble(d);
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> dateColumnWriter() {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$dateColumnWriter$1(dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeStringValues(DataOutputStream dos, Seq<String> vals) {
        this.writeFlags(dos, this.STRSXP, this.writeFlags$default$3(), this.writeFlags$default$4(), this.writeFlags$default$5(), this.writeFlags$default$6());
        this.writeLength(dos, vals.length());
        vals.map((Function1 & Serializable & scala.Serializable)x -> {
            RUtils$.MODULE$.writeStringValue(dos, x);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void writeStringValue(DataOutputStream dos, Object v) {
        this.writeFlags(dos, this.CHARSXP, this.writeFlags$default$3(), this.writeFlags$default$4(), this.writeFlags$default$5(), this.writeFlags$default$6());
        Object object = v;
        if (object instanceof String) {
            String string = (String)object;
            Serializer$.MODULE$.writeString(dos, string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.writeLength(dos, -1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Function3<DataOutputStream, Object, Iterator<Row>, BoxedUnit> arrayColumnWriter(int elemType, Function2<DataOutputStream, Object, BoxedUnit> elemWriter) {
        return (Function3 & Serializable & scala.Serializable)(dos, numRows, colIter) -> {
            RUtils$.$anonfun$arrayColumnWriter$1(elemType, elemWriter, dos, BoxesRunTime.unboxToInt((Object)numRows), colIter);
            return BoxedUnit.UNIT;
        };
    }

    private void writeFlags(DataOutputStream dos, int dtype, int levels, boolean isObj, boolean hasAttr, boolean hasTag) {
        dos.writeInt(dtype & 0xFF | new RichBoolean(Predef$.MODULE$.booleanWrapper(isObj)).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)) << 8 | new RichBoolean(Predef$.MODULE$.booleanWrapper(hasAttr)).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)) << 9 | new RichBoolean(Predef$.MODULE$.booleanWrapper(hasTag)).compare((Object)BoxesRunTime.boxToBoolean((boolean)false)) << 10 | levels << 12);
    }

    private int writeFlags$default$3() {
        return 0;
    }

    private boolean writeFlags$default$4() {
        return false;
    }

    private boolean writeFlags$default$5() {
        return false;
    }

    private boolean writeFlags$default$6() {
        return false;
    }

    private void writeLength(DataOutputStream dos, int length) {
        dos.writeInt(length);
    }

    public static final /* synthetic */ Object $anonfun$unserializeColumn$1(DataInputStream dis$1, Logger logger$1, long r) {
        RawSXP rawSXP;
        int elem_dtype = MODULE$.readDataType(dis$1);
        if (RUtils$.MODULE$.NILVALUE_SXP == elem_dtype) {
            rawSXP = null;
        } else {
            long num_elems = MODULE$.readLength(dis$1);
            if (RUtils$.MODULE$.RAWSXP == elem_dtype) {
                byte[] bytes = new byte[Predef$.MODULE$.long2Long(num_elems).intValue()];
                dis$1.readFully(bytes);
                rawSXP = new RawSXP(bytes);
            } else {
                Comparable<Boolean> comparable;
                if (1L != num_elems) {
                    throw new IllegalArgumentException(new StringBuilder(31).append("Unexpected number of elements: ").append(num_elems).toString());
                }
                int n = elem_dtype;
                if (RUtils$.MODULE$.LGLSXP == n) {
                    int v = Serializer$.MODULE$.readInt(dis$1);
                    comparable = RUtils$.MODULE$.NA_INTEGER == v ? null : BoxesRunTime.boxToBoolean((v != 0 ? 1 : 0) != 0);
                } else if (RUtils$.MODULE$.INTSXP == n) {
                    int v = Serializer$.MODULE$.readInt(dis$1);
                    comparable = RUtils$.MODULE$.NA_INTEGER == v ? null : BoxesRunTime.boxToInteger((int)v);
                } else if (RUtils$.MODULE$.REALSXP == n) {
                    byte[] bytes = new byte[8];
                    dis$1.readFully(bytes);
                    long hw = (long)MODULE$.extractInt(bytes, 0) & 0xFFFFFFFFL;
                    long lw = (long)MODULE$.extractInt(bytes, 4) & 0xFFFFFFFFL;
                    comparable = hw == 0x7FF00000L && lw == 1954L ? null : BoxesRunTime.boxToDouble((double)Double.longBitsToDouble(hw << 32 | lw));
                } else if (RUtils$.MODULE$.STRSXP == n) {
                    String string;
                    int strlen;
                    int ctype = MODULE$.readDataType(dis$1);
                    if (RUtils$.MODULE$.CHARSXP != ctype) {
                        logger$1.logWarning(new StringBuilder(53).append("Unexpected character type ").append(ctype).append(" found in string expression").toString());
                    }
                    if (-1L == (long)(strlen = Serializer$.MODULE$.readInt(dis$1))) {
                        string = null;
                    } else {
                        byte[] bytes = new byte[Predef$.MODULE$.int2Integer(strlen).intValue()];
                        dis$1.readFully(bytes);
                        string = new String(bytes, StandardCharsets.UTF_8);
                    }
                    comparable = string;
                } else {
                    throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(elem_dtype).toString());
                }
                rawSXP = comparable;
            }
        }
        return rawSXP;
    }

    public static final /* synthetic */ Object $anonfun$writeDataFrameHeader$2(Seq dtypes$1, ListBuffer timestampColIdxes$1, ListBuffer dateColIdxes$1, ListBuffer structColIdxes$1, int idx) {
        Object object;
        String colType = (String)((Tuple2)dtypes$1.apply(idx - 1))._2();
        String string = colType;
        if ("TimestampType".equals(string)) {
            object = timestampColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
        } else if ("DateType".equals(string)) {
            object = dateColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
        } else {
            Option option = Collectors$.MODULE$.ReTimestampArrayType().unapplySeq((CharSequence)string);
            if (!option.isEmpty()) {
                object = timestampColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
            } else {
                Option option2 = Collectors$.MODULE$.ReDateArrayType().unapplySeq((CharSequence)string);
                if (!option2.isEmpty()) {
                    object = dateColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
                } else {
                    String string2 = StructTypeAsJSON$.MODULE$.DType();
                    String string3 = string;
                    object = !(string2 != null ? !string2.equals(string3) : string3 != null) ? structColIdxes$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx)) : BoxedUnit.UNIT;
                }
            }
        }
        return object;
    }

    public static final /* synthetic */ void $anonfun$booleanColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.LGLSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            RUtils$.MODULE$.writeLglValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$rawColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.VECSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            RUtils$.MODULE$.writeRawValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$integralColumnWriter$1(Integral evidence$1$1, DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.INTSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            RUtils$.MODULE$.writeIntegralValue(dos, row.get(0), evidence$1$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ byte $anonfun$writeRawValue$1(Object x) {
        return BoxesRunTime.unboxToByte((Object)x);
    }

    public static final /* synthetic */ void $anonfun$numericColumnWriter$1(scala.math.Numeric evidence$3$1, DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.REALSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            RUtils$.MODULE$.writeNumericValue(dos, row.get(0), evidence$3$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$decimalColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.REALSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            RUtils$.MODULE$.writeDecimalValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$stringColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.STRSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            RUtils$.MODULE$.writeStringValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$timestampColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.REALSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            RUtils$.MODULE$.writeTimestampValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dateColumnWriter$1(DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.INTSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            RUtils$.MODULE$.writeDateValue(dos, row.get(0));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$arrayColumnWriter$1(int elemType$1, Function2 elemWriter$1, DataOutputStream dos, int numRows, Iterator colIter) {
        MODULE$.writeFlags(dos, RUtils$.MODULE$.VECSXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
        MODULE$.writeLength(dos, numRows);
        colIter.foreach((Function1 & Serializable & scala.Serializable)row -> {
            Object object;
            Object v = row.get(0);
            if (v == null) {
                MODULE$.writeFlags(dos, RUtils$.MODULE$.NILVALUE_SXP, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
                object = BoxedUnit.UNIT;
            } else {
                WrappedArray arr = (WrappedArray)v;
                MODULE$.writeFlags(dos, elemType$1, MODULE$.writeFlags$default$3(), MODULE$.writeFlags$default$4(), MODULE$.writeFlags$default$5(), MODULE$.writeFlags$default$6());
                MODULE$.writeLength(dos, arr.length());
                object = arr.map((Function1 & Serializable & scala.Serializable)b -> {
                    elemWriter$1.apply((Object)dos, b);
                    return BoxedUnit.UNIT;
                }, WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
            }
            return object;
        });
    }

    private RUtils$() {
        MODULE$ = this;
        this.XDR_FORMAT = (char)88;
        this.CHARSXP = 9;
        this.LGLSXP = 10;
        this.INTSXP = 13;
        this.REALSXP = 14;
        this.STRSXP = 16;
        this.VECSXP = 19;
        this.RAWSXP = 24;
        this.NILVALUE_SXP = 254;
        this.NA_INTEGER = Integer.MIN_VALUE;
    }
}

