% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soc_read.R
\name{soc_read}
\alias{soc_read}
\title{Read a Socrata Dataset into R}
\usage{
soc_read(url, query = soc_query(), alias = "label", page_size = 10000)
}
\arguments{
\item{url}{string; URL of the Socrata dataset.}

\item{query}{\code{soc_query()}; Query parameters specification}

\item{alias}{string; Use of field alias values. There are three options:
\itemize{
\item \code{"label"}: field alias values are assigned as a label attribute for each field.
\item \code{"replace"}: field alias values replace existing column names.
\item \code{"drop"}: field alias values replace existing column names.
}}

\item{page_size}{whole number; Maximum number of rows returned per request.}
}
\value{
A tibble with additional attributes containing dataset metadata.
If the dataset contains a single non-nested geospatial field, it will be returned as an \code{sf} object.

The returned object has the following attributes:
\describe{
\item{id}{Asset identifier (four-by-four ID).}
\item{name}{Asset name.}
\item{attribution}{Attribution or publisher of the asset.}
\item{owner_name}{Display name of the asset owner.}
\item{provenance}{Provenance of asset (official or community).}
\item{description}{Textual description of the asset.}
\item{created}{Date asset was created.}
\item{data_last_updated}{Date asset data was last updated}
\item{metadata_last_updated}{Date asset metadata was last updated}
\item{domain_category}{Category label assigned by the domain.}
\item{domain_tags}{Tags applied by the domain.}
\item{domain_metadata}{Metadata associated with the asset assigned by the domain.}
\item{columns}{A dataframe with the following columns:
\describe{
\item{column_name}{Names of asset columns.}
\item{column_label}{Labels of asset columns.}
\item{column_datatype}{Datatypes of asset columns.}
\item{column_description}{Description of asset columns.}
}
}
\item{permalink}{Permanent URL where the asset can be accessed.}
\item{link}{Direct asset link.}
\item{license}{License associated with the asset.}
}
}
\description{
Downloads and parses a dataset from a Socrata open data portal URL, returning it as a tibble or \code{sf} object.
Metadata is also returned as attributes on the returned object.
}
\examples{
\donttest{
soc_read(
  "https://soda.demo.socrata.com/dataset/USGS-Earthquakes-2012-11-08/3wfw-mdbc/"
)

soc_read(
  "https://soda.demo.socrata.com/dataset/USGS-Earthquakes-2012-11-08/3wfw-mdbc/",
  soc_query(
    select = "region, avg(magnitude) as avg_magnitude, count(*) as count",
    group_by = "region",
    having = "count >= 5",
    order_by = "avg_magnitude DESC"
  )
)
}

}
