% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.slcafit}
\alias{confint.slcafit}
\title{Confidence Intervals for Model Parameters}
\usage{
\method{confint}{slcafit}(object, parm, level = 0.95, type = c("param", "logit"), ...)
}
\arguments{
\item{object}{an object of class \code{slcafit}.}

\item{parm}{an integer or string specifying the parameters for which confidence intervals are to be computed.}

\item{level}{a numeric value representing the confidence level for the intervals. The default is \code{0.95} (95\% confidence level).}

\item{type}{a character string specifying the format in which the results should be returned. Options include \code{"probs"} for probability format and \code{"logit"} for log-odds (logit) format, with the default being \code{"probs"}.}

\item{...}{additional arguments.}
}
\value{
A \code{matrix} with two columns representing the confidence intervals for the selected parameters. The column names correspond to the specified confidence level:
\itemize{
\item \verb{100 * (level / 2)\%}: The lower bound of the confidence interval.
\item \verb{100 * (1 - level / 2)\%}: The upper bound of the confidence interval.
}

The \code{level} argument determines the confidence level, with common values being \code{0.95} for a 95\% confidence interval and \code{0.99} for a 99\% confidence interval.
}
\description{
Computes confidence intervals for one or more parameters of a fitted model.
}
\examples{
param(nlsy_jlcpa, index = TRUE)
confint(nlsy_jlcpa)
confint(nlsy_jlcpa, 1:4)
}
