% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.R
\name{compare}
\alias{compare}
\title{Compare Two Fitted \code{slca} Models}
\usage{
compare(
  model1,
  model2,
  test = c("none", "chisq", "boot"),
  nboot = 50,
  method = c("hybrid", "em", "nlm"),
  plot = FALSE,
  maxiter = 1000,
  tol = 1e-08,
  verbose = FALSE
)
}
\arguments{
\item{model1}{an object of class \code{slcafit}.}

\item{model2}{another object of class \code{slcafit} to be compared with \code{model1}.}

\item{test}{a character string specifying the type of test to be conducted. If \code{"chisq"}, a chi-squared test is conducted. If \code{"boot"}, a bootstrap test is conducted.}

\item{nboot}{an integer specifying the number of bootstrap iterations to perform (used only when \code{test = "boot"}). The default is 100.}

\item{method}{a character string specifying the estimation method for bootstrapping.}

\item{plot}{a logical value indicating whether to display a histogram of G-squared statistics for the bootstrap samples (applicable only for \code{test = "boot"}). The default is \code{FALSE}.}

\item{maxiter}{an integer specifying the maximum number of iterations allowed during each bootstrap estimation round. The default is 100.}

\item{tol}{numeric value setting the convergence tolerance for each bootstrap iteration. The default is \code{1e-6}.}

\item{verbose}{a logical value indicating whether to print progress updates on completed bootstrap iterations. The default is \code{FALSE}.}
}
\value{
A \code{data.frame} containing the number of parameters (Df), loglikelihood, AIC, BIC, G-squared statistics, and the residual degree of freedom for each object.
If a statistical test is conducted (via \code{test}), the resulting p-value for the comparison is also included.
}
\description{
Conducts a relative model fit test between two fitted SLCM models using the deviance statistic.
}
\examples{
library(magrittr)
data <- gss7677[gss7677$COHORT == "YOUNG", ]
stat2 <- slca(status(2) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))
stat3 <- slca(status(3) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))
stat4 <- slca(status(4) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))

gof(stat2, stat3, stat4)
gof(stat2, stat3, stat4, test = "chisq")
\donttest{
gof(stat2, stat3, stat4, test = "boot")
}

compare(stat3, stat4)
compare(stat3, stat4, test = "chisq")
\donttest{
compare(stat3, stat4, test = "boot")
}
}
\seealso{
\link[slca]{gof}
}
