% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{smnLX}
\alias{smnLX}
\title{Declination of southern minor Lunar Extreme for a given year}
\usage{
smnLX(
  year = skyscapeR.env$cur.year,
  loc = FALSE,
  parallax = 0.952,
  altitude = 0,
  verbose = TRUE
)
}
\arguments{
\item{year}{Year for which to calculate the declination.
Defaults to present year as given by \emph{Sys.Date}.}

\item{loc}{(Optional) This can be either the latitude of the
location, or a \emph{skyscapeR.horizon} object. If missing or \emph{FALSE},
function will output geocentric declination.}

\item{parallax}{(Optional) Average parallax value for the moon
Defaults to 0.952.}

\item{altitude}{(Optional) Altitude of the sun. Defaults to 0 degrees.}

\item{verbose}{(Optional) Boolean to control output of warnings and messages.
Defaults to TRUE.}
}
\description{
This function calculates the declination of the southern
minor Lunar Extreme for a given year, based upon
obliquity estimation and corrected average parallax.
}
\examples{
# Southern minor Lunar Extreme geocentric declination for year 2501 BC:
smnLX(-2500)

# Topocentric declination for same year and latitude of 50 degrees N:
smnLX(-2500, loc=50)
}
\seealso{
\code{\link{nmnLX}}, \code{\link{nMjLX}}, \code{\link{sMjLX}},
\code{\link{parallax.corr}}
}
