% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{set_na}
\alias{set_na}
\title{Set NA for specific variable values}
\usage{
set_na(var, values)
}
\arguments{
\item{var}{a variable where new missing values should be defined.}

\item{values}{a numeric vector with values that should be replaced with \code{\link{NA}}'s.}
}
\value{
The \code{var} where each value of \code{values} replaced by an \code{NA}.
}
\description{
This function sets specific values of a variable \code{var}
               as missings (\code{NA}).
}
\note{
Value and variable label attributes (see, for instance, \code{\link{get_val_labels}}
        or \code{\link{set_val_labels}}) are retained.
}
\examples{
# create random variable
dummy <- sample(1:8, 100, replace=TRUE)
# show value distribution
table(dummy)
# set value 1 and 8 as missings
dummy <- set_na(dummy, c(1,8))
# show value distribution, including missings
table(dummy, exclude=NULL)
}
\seealso{
\code{\link{rec}} for general recoding of variables and \code{\link{recode_to}}
           for re-shifting value ranges.
}

