% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simml.main.R
\name{generate.data}
\alias{generate.data}
\title{A data generation function}
\usage{
generate.data(n = 200, p = 10, family = "gaussian",
  correlationX = 0, sigmaX = 1, sigma = 0.4, s = 2, delta = 1,
  pi.1 = 0.5, true.beta = NULL, true.eta = NULL)
}
\arguments{
\item{n}{sample size.}

\item{p}{dimension of covariates.}

\item{family}{specifies the distribution of the outcome y;  "gaussian", "binomial", "poisson"; the defult is "gaussian"}

\item{correlationX}{correlation among the covariates.}

\item{sigmaX}{standard deviation of the covariates.}

\item{sigma}{standard deviation of the random noise term (for gaussian response).}

\item{s}{controls the nonliarity of the treatment-specific link functions that define the interaction effect component.
\describe{
\item{\code{s=1}}{linear}
\item{\code{s=2}}{nonlinear}
}}

\item{delta}{controls the intensity of the main effect; can take any intermediate value, e.g., \code{delta= 1.4}.
\describe{
\item{\code{delta=1}}{moderate main effect}
\item{\code{delta=2}}{big main effect}
}}

\item{pi.1}{probability of being assigned to the treatment 1}

\item{true.beta}{a p-by-1 vector of the true single-index coefficients (associated with the interaction effect component); if \code{NULL}, \code{true.beta} is set to be \code{(1, 0.5, 0.25, 0.125, 0,...0)}' (only the first 4 elements are nonzero).}

\item{true.eta}{a p-by-1 vector of the true main effect coefficients; if \code{NULL}, \code{true.eta} is set to be \code{(0,..., 0.125, 0.25, 0.25, 1)}' (only the last 4 elements are nonzero).}
}
\value{
\item{y}{a n-by-1 vector of treatment outcomes.}
\item{A}{a n-by-1 vector of treatment indicators.}
\item{X}{a n-by-p matrix of pretreatment covariates.}
\item{SNR}{the "signal" (interaction effect) to "nuisance" (main effect) variance ratio (SNR) in the canonical parameter function.}
\item{true.beta}{the true single-index coefficient vector.}
\item{true.eta}{the true main effect coefficient vector.}
\item{optTr}{a n-by-1 vector of treatments, indicating the optimal treatment selections.}
\item{value.opt}{the "value" implied by the optimal treatment decision rule, \code{optTr}.}
}
\description{
\code{generate.data} generates an example dataset from a mean model that has a "main" effect component and a treatment-by-covariates interaction effect component (and a random component for noise).
}
