% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sim_dina_attributes}
\alias{sim_dina_attributes}
\title{Simulate a DINA Model's \eqn{\eta} Matrix}
\usage{
sim_dina_attributes(alphas, Q)
}
\arguments{
\item{alphas}{A \eqn{N} by \eqn{K} \code{matrix} of latent attributes.}

\item{Q}{A \eqn{J} by \eqn{K} \code{matrix} indicating which skills are required
for which items.}
}
\value{
The \eqn{\eta} \code{matrix} with dimensions \eqn{N \times J}{N x J} under
the DINA model.
}
\description{
Generates a DINA model's \eqn{\eta} matrix based on alphas and
the \eqn{\mathbf{Q}} matrix.
}
\examples{
N = 200
K = 5
J = 30
delta0 = rep(1, 2 ^ K)

# Creating Q matrix
Q = matrix(rep(diag(K), 2), 2 * K, K, byrow = TRUE)
for (mm in 2:K) {
  temp = combn(seq_len(K), m = mm)
  tempmat = matrix(0, ncol(temp), K)
  for (j in seq_len(ncol(temp)))
    tempmat[j, temp[, j]] = 1
  Q = rbind(Q, tempmat)
}
Q = Q[seq_len(J), ]

# Setting item parameters and generating attribute profiles
ss = gs = rep(.2, J)
PIs = rep(1 / (2 ^ K), 2 ^ K)
CLs = c((1:(2 ^ K)) \%*\% rmultinom(n = N, size = 1, prob = PIs))

# Defining matrix of possible attribute profiles
As = rep(0, K)
for (j in seq_len(K)) {
  temp = combn(1:K, m = j)
  tempmat = matrix(0, ncol(temp), K)
  for (j in seq_len(ncol(temp)))
    tempmat[j, temp[, j]] = 1
  As = rbind(As, tempmat)
}
As = as.matrix(As)

# Sample true attribute profiles
Alphas = As[CLs, ]

# Simulate item data under DINA model 
dina_items = sim_dina_items(Alphas, Q, ss, gs)

# Simulate attribute data under DINA model 
dina_attributes = sim_dina_attributes(Alphas, Q)
}
\seealso{
\code{\link[simcdm:sim_dina_class]{simcdm::sim_dina_class()}} and \code{\link[simcdm:sim_dina_items]{simcdm::sim_dina_items()}}
}
\author{
Steven Andrew Culpepper and James Joseph Balamuta
}
