% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizationFunction.R
\name{unnormalizeData}
\alias{unnormalizeData}
\title{Unnormalization of given data}
\usage{
unnormalizeData(dataInput)
}
\arguments{
\item{dataInput}{a list file composes of two parts
First part is the data that will be unnormalized, which is a data frame composed of two columns. One is for time and the other is for intensity
Second part is the scaling parameters of the data which is a vector that has three components. The first one of them is related with time and last two of them are related with intensity. The second value represents the min value of the intensity set. First and third values represent the difference between max and min value in the relevant column.}
}
\value{
Returns a data frame, scaling factors and scaling constants for time and intensity. The other data frame includes 2 columns one is for normalized time and the other is for noralized intensity. The whole time is distributed between 0 and 1 and similarly the whole intensity is distributed between 0 and 1. The time and intensity constants and scaling factors are the parameters to transform data from given set to scaled set.
}
\description{
Maps the given time-intensity data into a rescaled frame where time is between [0,1] and similarly intensity is between [0,1].
}
\examples{
# generateRandomData
time <- seq(3, 48, 0.5)
intensity <- runif(length(time), 3.0, 7.5)
dataInput <- data.frame(time, intensity)
# Normalize Data
dataOutput <- normalizeData(dataInput)
dataInput2 <- dataOutput
# Un Normalize it
dataOutput2 <- unnormalizeData(dataInput2)

}
