% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Pull_Cluster_Annotation}
\alias{Pull_Cluster_Annotation}
\title{Pull cluster information from annotation csv file.}
\usage{
Pull_Cluster_Annotation(
  annotation = NULL,
  cluster_name_col = "cluster",
  cell_type_col = "cell_type"
)
}
\arguments{
\item{annotation}{name of the data.frame/tibble or path to CSV file containing cluster annotation.}

\item{cluster_name_col}{name of column containing cluster names/numbers (default is "cluster").}

\item{cell_type_col}{name of column contain the cell type annotation (default is "cell_type").}
}
\value{
a list of named vectors for every cell type in the \code{cell_type_col} column of the annotation table and
vectors new cluster names (for use with \code{Rename_Clusters} function or manual identity renaming).
}
\description{
shortcut filter and pull function compatible with annotation files created by \code{Create_Cluster_Annotation_File}
by default but also any other csv file.
}
\examples{
\dontrun{
# If pulling from a data.frame/tibble
cluster_annotation <- Pull_Cluster_Annotation(annotation = annotation_df,
cluster_name_col = "cluster", cell_type_col = "cell_type")

# If pulling from csv file
cluster_annotation <- Pull_Cluster_Annotation(annotation = "file_path/file_name.csv",
cluster_name_col = "cluster", cell_type_col = "cell_type")
}

}
\concept{marker_annotation_util}
