// Generated by rstantools.  Do not edit by hand.

/*
    rts2 is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rts2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rts2.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_lgcp_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 137> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 80, column 2 to column 55)",
  " (in 'string', line 81, column 2 to column 57)",
  " (in 'string', line 82, column 2 to column 18)",
  " (in 'string', line 83, column 2 to column 50)",
  " (in 'string', line 84, column 2 to column 31)",
  " (in 'string', line 87, column 2 to column 28)",
  " (in 'string', line 88, column 2 to column 23)",
  " (in 'string', line 89, column 2 to column 26)",
  " (in 'string', line 90, column 2 to column 24)",
  " (in 'string', line 129, column 2 to column 36)",
  " (in 'string', line 95, column 4 to column 27)",
  " (in 'string', line 96, column 4 to column 23)",
  " (in 'string', line 94, column 9 to line 97, column 3)",
  " (in 'string', line 92, column 4 to column 23)",
  " (in 'string', line 93, column 4 to column 19)",
  " (in 'string', line 91, column 15 to line 94, column 3)",
  " (in 'string', line 91, column 2 to line 97, column 3)",
  " (in 'string', line 102, column 4 to column 15)",
  " (in 'string', line 101, column 9 to line 103, column 3)",
  " (in 'string', line 100, column 4 to column 49)",
  " (in 'string', line 99, column 17 to line 101, column 3)",
  " (in 'string', line 99, column 2 to line 103, column 3)",
  " (in 'string', line 112, column 6 to column 29)",
  " (in 'string', line 111, column 11 to line 113, column 5)",
  " (in 'string', line 109, column 8 to column 140)",
  " (in 'string', line 108, column 13 to line 110, column 7)",
  " (in 'string', line 107, column 8 to column 69)",
  " (in 'string', line 106, column 14 to line 108, column 7)",
  " (in 'string', line 106, column 6 to line 110, column 7)",
  " (in 'string', line 105, column 12 to line 111, column 5)",
  " (in 'string', line 105, column 4 to line 113, column 5)",
  " (in 'string', line 104, column 16 to line 114, column 3)",
  " (in 'string', line 104, column 2 to line 114, column 3)",
  " (in 'string', line 131, column 4 to column 60)",
  " (in 'string', line 130, column 26 to line 132, column 3)",
  " (in 'string', line 130, column 2 to line 132, column 3)",
  " (in 'string', line 118, column 4 to column 56)",
  " (in 'string', line 119, column 4 to column 52)",
  " (in 'string', line 117, column 16 to line 120, column 3)",
  " (in 'string', line 117, column 2 to line 120, column 3)",
  " (in 'string', line 121, column 13 to column 30)",
  " (in 'string', line 121, column 2 to column 30)",
  " (in 'string', line 123, column 4 to column 65)",
  " (in 'string', line 122, column 15 to line 124, column 3)",
  " (in 'string', line 122, column 2 to line 124, column 3)",
  " (in 'string', line 125, column 2 to column 23)",
  " (in 'string', line 126, column 2 to column 40)",
  " (in 'string', line 46, column 2 to column 17)",
  " (in 'string', line 47, column 2 to column 17)",
  " (in 'string', line 48, column 2 to column 23)",
  " (in 'string', line 49, column 2 to column 9)",
  " (in 'string', line 50, column 8 to column 18)",
  " (in 'string', line 50, column 2 to column 26)",
  " (in 'string', line 51, column 9 to column 16)",
  " (in 'string', line 51, column 17 to column 18)",
  " (in 'string', line 51, column 2 to column 27)",
  " (in 'string', line 52, column 9 to column 19)",
  " (in 'string', line 52, column 2 to column 29)",
  " (in 'string', line 53, column 9 to column 19)",
  " (in 'string', line 53, column 20 to column 21)",
  " (in 'string', line 53, column 2 to column 25)",
  " (in 'string', line 54, column 2 to column 29)",
  " (in 'string', line 55, column 2 to column 26)",
  " (in 'string', line 56, column 8 to column 9)",
  " (in 'string', line 56, column 2 to column 35)",
  " (in 'string', line 57, column 8 to column 9)",
  " (in 'string', line 57, column 2 to column 33)",
  " (in 'string', line 58, column 2 to column 10)",
  " (in 'string', line 59, column 2 to column 38)",
  " (in 'string', line 60, column 2 to column 27)",
  " (in 'string', line 61, column 2 to column 25)",
  " (in 'string', line 64, column 9 to column 19)",
  " (in 'string', line 64, column 2 to column 32)",
  " (in 'string', line 65, column 9 to column 32)",
  " (in 'string', line 65, column 34 to column 57)",
  " (in 'string', line 65, column 2 to column 66)",
  " (in 'string', line 66, column 8 to column 33)",
  " (in 'string', line 66, column 2 to column 46)",
  " (in 'string', line 67, column 2 to column 28)",
  " (in 'string', line 70, column 6 to line 71, column 73)",
  " (in 'string', line 69, column 27 to line 72, column 5)",
  " (in 'string', line 69, column 4 to line 72, column 5)",
  " (in 'string', line 68, column 25 to line 73, column 3)",
  " (in 'string', line 68, column 2 to line 73, column 3)",
  " (in 'string', line 76, column 4 to column 64)",
  " (in 'string', line 75, column 15 to line 77, column 3)",
  " (in 'string', line 75, column 2 to line 77, column 3)",
  " (in 'string', line 80, column 8 to column 25)",
  " (in 'string', line 81, column 8 to column 25)",
  " (in 'string', line 82, column 9 to column 10)",
  " (in 'string', line 83, column 8 to column 22)",
  " (in 'string', line 84, column 8 to column 18)",
  " (in 'string', line 87, column 9 to column 16)",
  " (in 'string', line 87, column 17 to column 24)",
  " (in 'string', line 88, column 9 to column 19)",
  " (in 'string', line 129, column 9 to column 19)",
  " (in 'string', line 3, column 11 to column 12)",
  " (in 'string', line 3, column 13 to column 14)",
  " (in 'string', line 3, column 4 to column 38)",
  " (in 'string', line 4, column 4 to column 11)",
  " (in 'string', line 5, column 4 to column 14)",
  " (in 'string', line 6, column 4 to column 19)",
  " (in 'string', line 7, column 4 to column 12)",
  " (in 'string', line 10, column 6 to column 16)",
  " (in 'string', line 11, column 6 to column 24)",
  " (in 'string', line 15, column 8 to column 46)",
  " (in 'string', line 14, column 14 to line 16, column 7)",
  " (in 'string', line 13, column 8 to column 61)",
  " (in 'string', line 12, column 18 to line 14, column 7)",
  " (in 'string', line 12, column 6 to line 16, column 7)",
  " (in 'string', line 9, column 17 to line 17, column 5)",
  " (in 'string', line 9, column 4 to line 17, column 5)",
  " (in 'string', line 20, column 6 to column 12)",
  " (in 'string', line 22, column 8 to column 30)",
  " (in 'string', line 21, column 23 to line 23, column 7)",
  " (in 'string', line 21, column 6 to line 23, column 7)",
  " (in 'string', line 24, column 6 to column 31)",
  " (in 'string', line 27, column 10 to column 58)",
  " (in 'string', line 29, column 10 to column 28)",
  " (in 'string', line 30, column 10 to column 16)",
  " (in 'string', line 32, column 12 to column 34)",
  " (in 'string', line 31, column 27 to line 33, column 11)",
  " (in 'string', line 31, column 10 to line 33, column 11)",
  " (in 'string', line 37, column 12 to column 63)",
  " (in 'string', line 36, column 18 to line 38, column 11)",
  " (in 'string', line 35, column 12 to column 79)",
  " (in 'string', line 34, column 22 to line 36, column 11)",
  " (in 'string', line 34, column 10 to line 38, column 11)",
  " (in 'string', line 26, column 25 to line 39, column 9)",
  " (in 'string', line 26, column 8 to line 39, column 9)",
  " (in 'string', line 25, column 15 to line 40, column 7)",
  " (in 'string', line 25, column 6 to line 40, column 7)",
  " (in 'string', line 19, column 17 to line 41, column 5)",
  " (in 'string', line 19, column 4 to line 41, column 5)",
  " (in 'string', line 42, column 4 to column 13)",
  " (in 'string', line 2, column 76 to line 43, column 3)"};
template <typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<T1__, T2__, T3__>,-1,-1>
genChol(const int& n, const T1__& alpha, const T2__& theta,
        const std::vector<T3__>& dists, const int& mod, std::ostream*
        pstream__);
template <typename T1__, typename T2__, typename T3__,
          stan::require_all_t<stan::is_stan_scalar<T1__>,
                              stan::is_stan_scalar<T2__>,
                              stan::is_stan_scalar<T3__>>*>
Eigen::Matrix<stan::promote_args_t<T1__, T2__, T3__>,-1,-1>
genChol(const int& n, const T1__& alpha, const T2__& theta,
        const std::vector<T3__>& dists, const int& mod, std::ostream*
        pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T1__, T2__, T3__>;
  int current_statement__ = 0;
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 97;
    stan::math::validate_non_negative_index("L", "n", n);
    current_statement__ = 98;
    stan::math::validate_non_negative_index("L", "n", n);
    Eigen::Matrix<local_scalar_t__,-1,-1> L =
      Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(n, n, DUMMY_VAR__);
    current_statement__ = 99;
    stan::model::assign(L, stan::math::rep_matrix(0, n, n),
      "assigning variable L");
    local_scalar_t__ s = DUMMY_VAR__;
    local_scalar_t__ dist = DUMMY_VAR__;
    current_statement__ = 102;
    stan::model::assign(L, alpha, "assigning variable L",
      stan::model::index_uni(1), stan::model::index_uni(1));
    int idx = std::numeric_limits<int>::min();
    current_statement__ = 112;
    for (int i = 2; i <= n; ++i) {
      current_statement__ = 104;
      idx = (i - 1);
      current_statement__ = 105;
      dist = stan::model::rvalue(dists, "dists", stan::model::index_uni(idx));
      current_statement__ = 110;
      if (stan::math::logical_eq(mod, 0)) {
        current_statement__ = 108;
        stan::model::assign(L, (alpha *
          stan::math::exp(((-1.0 * (dist * dist)) / (theta * theta)))),
          "assigning variable L", stan::model::index_uni(i),
          stan::model::index_uni(1));
      } else {
        current_statement__ = 106;
        stan::model::assign(L, (alpha *
          stan::math::exp(((-1.0 * dist) / theta))), "assigning variable L",
          stan::model::index_uni(i), stan::model::index_uni(1));
      }
    }
    current_statement__ = 134;
    for (int j = 2; j <= n; ++j) {
      current_statement__ = 113;
      s = 0;
      current_statement__ = 116;
      for (int k = 1; k <= (j - 1); ++k) {
        current_statement__ = 114;
        s = (s +
          (stan::model::rvalue(L, "L", stan::model::index_uni(j),
             stan::model::index_uni(k))
          *
          stan::model::rvalue(L, "L", stan::model::index_uni(j),
            stan::model::index_uni(k))));
      }
      current_statement__ = 117;
      stan::model::assign(L, stan::math::sqrt((alpha - s)),
        "assigning variable L", stan::model::index_uni(j),
        stan::model::index_uni(j));
      current_statement__ = 132;
      if (stan::math::logical_lt(j, n)) {
        current_statement__ = 130;
        for (int i = (j + 1); i <= n; ++i) {
          current_statement__ = 118;
          idx = (((((n - 1) * (j - 1)) - (((j - 2) * (j - 1)) / 2)) + ((i -
            j) - 1)) + 1);
          current_statement__ = 119;
          dist = stan::model::rvalue(dists, "dists",
                   stan::model::index_uni(idx));
          current_statement__ = 120;
          s = 0;
          current_statement__ = 123;
          for (int k = 1; k <= (j - 1); ++k) {
            current_statement__ = 121;
            s = (s +
              (stan::model::rvalue(L, "L", stan::model::index_uni(j),
                 stan::model::index_uni(k))
              *
              stan::model::rvalue(L, "L", stan::model::index_uni(i),
                stan::model::index_uni(k))));
          }
          current_statement__ = 128;
          if (stan::math::logical_eq(mod, 0)) {
            current_statement__ = 126;
            stan::model::assign(L, ((1 /
              stan::model::rvalue(L, "L", stan::model::index_uni(j),
                stan::model::index_uni(j))) * ((alpha *
              stan::math::exp((-(dist * dist) / (theta * theta)))) - s)),
              "assigning variable L", stan::model::index_uni(i),
              stan::model::index_uni(j));
          } else {
            current_statement__ = 124;
            stan::model::assign(L, ((1 /
              stan::model::rvalue(L, "L", stan::model::index_uni(j),
                stan::model::index_uni(j))) * ((alpha *
              stan::math::exp((-dist / theta))) - s)),
              "assigning variable L", stan::model::index_uni(i),
              stan::model::index_uni(j));
          }
        }
      }
    }
    current_statement__ = 135;
    return L;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_lgcp final : public model_base_crtp<model_lgcp> {
private:
  int D;
  int Q;
  int Nsample;
  int nT;
  std::vector<int> y;
  Eigen::Matrix<double,-1,-1> x_grid_data__;
  Eigen::Matrix<double,-1,1> popdens_data__;
  Eigen::Matrix<double,-1,-1> X_data__;
  std::vector<double> prior_lscale;
  std::vector<double> prior_var;
  std::vector<double> prior_linpred_mean;
  std::vector<double> prior_linpred_sd;
  int mod;
  int known_cov;
  double sigma_data;
  double phi_data;
  Eigen::Matrix<double,-1,1> logpopdens_data__;
  Eigen::Matrix<double,-1,-1> L_data_data__;
  std::vector<double> dists;
  int phi_param_1dim__;
  int sigma_param_1dim__;
  int ar_1dim__;
  int f_raw_1dim__;
  int f_1dim__;
  int y_grid_predict_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> x_grid{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> popdens{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> X{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> logpopdens{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> L_data{nullptr, 0, 0};
public:
  ~model_lgcp() {}
  model_lgcp(stan::io::var_context& context__, unsigned int
             random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_lgcp_namespace::model_lgcp";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 48;
      context__.validate_dims("data initialization", "D", "int",
        std::vector<size_t>{});
      D = std::numeric_limits<int>::min();
      current_statement__ = 48;
      D = context__.vals_i("D")[(1 - 1)];
      current_statement__ = 48;
      stan::math::check_greater_or_equal(function__, "D", D, 1);
      current_statement__ = 49;
      context__.validate_dims("data initialization", "Q", "int",
        std::vector<size_t>{});
      Q = std::numeric_limits<int>::min();
      current_statement__ = 49;
      Q = context__.vals_i("Q")[(1 - 1)];
      current_statement__ = 49;
      stan::math::check_greater_or_equal(function__, "Q", Q, 1);
      current_statement__ = 50;
      context__.validate_dims("data initialization", "Nsample", "int",
        std::vector<size_t>{});
      Nsample = std::numeric_limits<int>::min();
      current_statement__ = 50;
      Nsample = context__.vals_i("Nsample")[(1 - 1)];
      current_statement__ = 50;
      stan::math::check_greater_or_equal(function__, "Nsample", Nsample, 1);
      current_statement__ = 51;
      context__.validate_dims("data initialization", "nT", "int",
        std::vector<size_t>{});
      nT = std::numeric_limits<int>::min();
      current_statement__ = 51;
      nT = context__.vals_i("nT")[(1 - 1)];
      current_statement__ = 52;
      stan::math::validate_non_negative_index("y", "Nsample * nT", (Nsample *
        nT));
      current_statement__ = 53;
      context__.validate_dims("data initialization", "y", "int",
        std::vector<size_t>{static_cast<size_t>((Nsample * nT))});
      y = std::vector<int>((Nsample * nT), std::numeric_limits<int>::min());
      current_statement__ = 53;
      y = context__.vals_i("y");
      current_statement__ = 54;
      stan::math::validate_non_negative_index("x_grid", "Nsample", Nsample);
      current_statement__ = 55;
      stan::math::validate_non_negative_index("x_grid", "D", D);
      current_statement__ = 56;
      context__.validate_dims("data initialization", "x_grid", "double",
        std::vector<size_t>{static_cast<size_t>(Nsample),
          static_cast<size_t>(D)});
      x_grid_data__ = Eigen::Matrix<double,-1,-1>::Constant(Nsample, D,
                        std::numeric_limits<double>::quiet_NaN());
      new (&x_grid)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(x_grid_data__.data(),
        Nsample, D);
      {
        std::vector<local_scalar_t__> x_grid_flat__;
        current_statement__ = 56;
        x_grid_flat__ = context__.vals_r("x_grid");
        current_statement__ = 56;
        pos__ = 1;
        current_statement__ = 56;
        for (int sym1__ = 1; sym1__ <= D; ++sym1__) {
          current_statement__ = 56;
          for (int sym2__ = 1; sym2__ <= Nsample; ++sym2__) {
            current_statement__ = 56;
            stan::model::assign(x_grid, x_grid_flat__[(pos__ - 1)],
              "assigning variable x_grid", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 56;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 57;
      stan::math::validate_non_negative_index("popdens", "Nsample * nT",
        (Nsample * nT));
      current_statement__ = 58;
      context__.validate_dims("data initialization", "popdens", "double",
        std::vector<size_t>{static_cast<size_t>((Nsample * nT))});
      popdens_data__ = Eigen::Matrix<double,-1,1>::Constant((Nsample * nT),
                         std::numeric_limits<double>::quiet_NaN());
      new (&popdens)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(popdens_data__.data(),
        (Nsample * nT));
      {
        std::vector<local_scalar_t__> popdens_flat__;
        current_statement__ = 58;
        popdens_flat__ = context__.vals_r("popdens");
        current_statement__ = 58;
        pos__ = 1;
        current_statement__ = 58;
        for (int sym1__ = 1; sym1__ <= (Nsample * nT); ++sym1__) {
          current_statement__ = 58;
          stan::model::assign(popdens, popdens_flat__[(pos__ - 1)],
            "assigning variable popdens", stan::model::index_uni(sym1__));
          current_statement__ = 58;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 59;
      stan::math::validate_non_negative_index("X", "Nsample * nT", (Nsample *
        nT));
      current_statement__ = 60;
      stan::math::validate_non_negative_index("X", "Q", Q);
      current_statement__ = 61;
      context__.validate_dims("data initialization", "X", "double",
        std::vector<size_t>{static_cast<size_t>((Nsample * nT)),
          static_cast<size_t>(Q)});
      X_data__ = Eigen::Matrix<double,-1,-1>::Constant((Nsample * nT), Q,
                   std::numeric_limits<double>::quiet_NaN());
      new (&X) Eigen::Map<Eigen::Matrix<double,-1,-1>>(X_data__.data(),
        (Nsample * nT), Q);
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 61;
        X_flat__ = context__.vals_r("X");
        current_statement__ = 61;
        pos__ = 1;
        current_statement__ = 61;
        for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
          current_statement__ = 61;
          for (int sym2__ = 1; sym2__ <= (Nsample * nT); ++sym2__) {
            current_statement__ = 61;
            stan::model::assign(X, X_flat__[(pos__ - 1)],
              "assigning variable X", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 61;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 62;
      context__.validate_dims("data initialization", "prior_lscale",
        "double", std::vector<size_t>{static_cast<size_t>(2)});
      prior_lscale = std::vector<double>(2,
                       std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 62;
      prior_lscale = context__.vals_r("prior_lscale");
      current_statement__ = 63;
      context__.validate_dims("data initialization", "prior_var", "double",
        std::vector<size_t>{static_cast<size_t>(2)});
      prior_var = std::vector<double>(2,
                    std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 63;
      prior_var = context__.vals_r("prior_var");
      current_statement__ = 64;
      stan::math::validate_non_negative_index("prior_linpred_mean", "Q", Q);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "prior_linpred_mean",
        "double", std::vector<size_t>{static_cast<size_t>(Q)});
      prior_linpred_mean = std::vector<double>(Q,
                             std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 65;
      prior_linpred_mean = context__.vals_r("prior_linpred_mean");
      current_statement__ = 66;
      stan::math::validate_non_negative_index("prior_linpred_sd", "Q", Q);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "prior_linpred_sd",
        "double", std::vector<size_t>{static_cast<size_t>(Q)});
      prior_linpred_sd = std::vector<double>(Q,
                           std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 67;
      prior_linpred_sd = context__.vals_r("prior_linpred_sd");
      current_statement__ = 68;
      context__.validate_dims("data initialization", "mod", "int",
        std::vector<size_t>{});
      mod = std::numeric_limits<int>::min();
      current_statement__ = 68;
      mod = context__.vals_i("mod")[(1 - 1)];
      current_statement__ = 69;
      context__.validate_dims("data initialization", "known_cov", "int",
        std::vector<size_t>{});
      known_cov = std::numeric_limits<int>::min();
      current_statement__ = 69;
      known_cov = context__.vals_i("known_cov")[(1 - 1)];
      current_statement__ = 69;
      stan::math::check_greater_or_equal(function__, "known_cov", known_cov,
        0);
      current_statement__ = 69;
      stan::math::check_less_or_equal(function__, "known_cov", known_cov, 1);
      current_statement__ = 70;
      context__.validate_dims("data initialization", "sigma_data", "double",
        std::vector<size_t>{});
      sigma_data = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 70;
      sigma_data = context__.vals_r("sigma_data")[(1 - 1)];
      current_statement__ = 70;
      stan::math::check_greater_or_equal(function__, "sigma_data",
        sigma_data, 0);
      current_statement__ = 71;
      context__.validate_dims("data initialization", "phi_data", "double",
        std::vector<size_t>{});
      phi_data = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 71;
      phi_data = context__.vals_r("phi_data")[(1 - 1)];
      current_statement__ = 71;
      stan::math::check_greater_or_equal(function__, "phi_data", phi_data, 0);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("logpopdens", "Nsample * nT",
        (Nsample * nT));
      current_statement__ = 73;
      logpopdens_data__ = Eigen::Matrix<double,-1,1>::Constant((Nsample *
                            nT), std::numeric_limits<double>::quiet_NaN());
      new (&logpopdens)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(logpopdens_data__.data(),
        (Nsample * nT));
      current_statement__ = 74;
      stan::math::validate_non_negative_index("L_data",
        "known_cov ? Nsample : 0", (known_cov ? Nsample : 0));
      current_statement__ = 75;
      stan::math::validate_non_negative_index("L_data",
        "known_cov ? Nsample : 0", (known_cov ? Nsample : 0));
      current_statement__ = 76;
      L_data_data__ = Eigen::Matrix<double,-1,-1>::Constant((known_cov ? Nsample : 0),
                        (known_cov ? Nsample : 0),
                        std::numeric_limits<double>::quiet_NaN());
      new (&L_data)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(L_data_data__.data(),
        (known_cov ? Nsample : 0), (known_cov ? Nsample : 0));
      current_statement__ = 77;
      stan::math::validate_non_negative_index("dists",
        "(Nsample * (Nsample - 1)) %/% 2", ((Nsample * (Nsample - 1)) / 2));
      current_statement__ = 78;
      dists = std::vector<double>(((Nsample * (Nsample - 1)) / 2),
                std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 79;
      stan::model::assign(logpopdens, stan::math::log(popdens),
        "assigning variable logpopdens");
      current_statement__ = 84;
      for (int i = 1; i <= (Nsample - 1); ++i) {
        current_statement__ = 82;
        for (int j = (i + 1); j <= Nsample; ++j) {
          current_statement__ = 80;
          stan::model::assign(dists,
            stan::math::sqrt(
              (((stan::model::rvalue(x_grid, "x_grid",
                   stan::model::index_uni(i), stan::model::index_uni(1)) -
              stan::model::rvalue(x_grid, "x_grid",
                stan::model::index_uni(j), stan::model::index_uni(1))) *
              (stan::model::rvalue(x_grid, "x_grid",
                 stan::model::index_uni(i), stan::model::index_uni(1)) -
              stan::model::rvalue(x_grid, "x_grid",
                stan::model::index_uni(j), stan::model::index_uni(1)))) +
              ((stan::model::rvalue(x_grid, "x_grid",
                  stan::model::index_uni(i), stan::model::index_uni(2)) -
              stan::model::rvalue(x_grid, "x_grid",
                stan::model::index_uni(j), stan::model::index_uni(2))) *
              (stan::model::rvalue(x_grid, "x_grid",
                 stan::model::index_uni(i), stan::model::index_uni(2)) -
              stan::model::rvalue(x_grid, "x_grid",
                stan::model::index_uni(j), stan::model::index_uni(2)))))),
            "assigning variable dists",
            stan::model::index_uni((((((Nsample - 1) * (i - 1)) - (((i - 2) *
              (i - 1)) / 2)) + ((j - i) - 1)) + 1)));
        }
      }
      current_statement__ = 87;
      if (known_cov) {
        current_statement__ = 85;
        stan::model::assign(L_data,
          genChol(Nsample, sigma_data, phi_data, dists, mod, pstream__),
          "assigning variable L_data");
      }
      current_statement__ = 88;
      phi_param_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 88;
      phi_param_1dim__ = (known_cov ? 0 : 1);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("phi_param",
        "known_cov ? 0 : 1", phi_param_1dim__);
      current_statement__ = 89;
      sigma_param_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 89;
      sigma_param_1dim__ = (known_cov ? 0 : 1);
      current_statement__ = 89;
      stan::math::validate_non_negative_index("sigma_param",
        "known_cov ? 0 : 1", sigma_param_1dim__);
      current_statement__ = 90;
      stan::math::validate_non_negative_index("gamma", "Q", Q);
      current_statement__ = 91;
      ar_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 91;
      ar_1dim__ = (stan::math::logical_gt(nT, 1) ? 0 : 1);
      current_statement__ = 91;
      stan::math::validate_non_negative_index("ar", "nT > 1 ? 0 : 1",
        ar_1dim__);
      current_statement__ = 92;
      f_raw_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 92;
      f_raw_1dim__ = (Nsample * nT);
      current_statement__ = 92;
      stan::math::validate_non_negative_index("f_raw", "Nsample * nT",
        f_raw_1dim__);
      current_statement__ = 93;
      stan::math::validate_non_negative_index("L", "Nsample", Nsample);
      current_statement__ = 94;
      stan::math::validate_non_negative_index("L", "Nsample", Nsample);
      current_statement__ = 95;
      f_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 95;
      f_1dim__ = (Nsample * nT);
      current_statement__ = 95;
      stan::math::validate_non_negative_index("f", "Nsample * nT", f_1dim__);
      current_statement__ = 96;
      y_grid_predict_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 96;
      y_grid_predict_1dim__ = (Nsample * nT);
      current_statement__ = 96;
      stan::math::validate_non_negative_index("y_grid_predict",
        "Nsample * nT", y_grid_predict_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = phi_param_1dim__ + sigma_param_1dim__ + Q + ar_1dim__ +
      f_raw_1dim__;
  }
  inline std::string model_name() const final {
    return "model_lgcp";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_lgcp_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<local_scalar_t__> phi_param =
        std::vector<local_scalar_t__>(phi_param_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      phi_param = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(1e-05, lp__,
                    phi_param_1dim__);
      std::vector<local_scalar_t__> sigma_param =
        std::vector<local_scalar_t__>(sigma_param_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      sigma_param = in__.template read_constrain_lb<
                      std::vector<local_scalar_t__>, jacobian__>(1e-05, lp__,
                      sigma_param_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Q, DUMMY_VAR__);
      current_statement__ = 3;
      gamma = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(Q);
      std::vector<local_scalar_t__> ar =
        std::vector<local_scalar_t__>(ar_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      ar = in__.template read_constrain_lub<std::vector<local_scalar_t__>,
             jacobian__>(-1, 1, lp__, ar_1dim__);
      std::vector<local_scalar_t__> f_raw =
        std::vector<local_scalar_t__>(f_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      f_raw = in__.template read<std::vector<local_scalar_t__>>(f_raw_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,-1> L =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(Nsample, Nsample,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> f =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(f_1dim__, DUMMY_VAR__);
      local_scalar_t__ sigma = DUMMY_VAR__;
      local_scalar_t__ phi = DUMMY_VAR__;
      current_statement__ = 17;
      if (known_cov) {
        current_statement__ = 14;
        sigma = sigma_data;
        current_statement__ = 15;
        phi = phi_data;
      } else {
        current_statement__ = 11;
        sigma = stan::model::rvalue(sigma_param, "sigma_param",
                  stan::model::index_uni(1));
        current_statement__ = 12;
        phi = stan::model::rvalue(phi_param, "phi_param",
                stan::model::index_uni(1));
      }
      current_statement__ = 22;
      if (stan::math::logical_negation(known_cov)) {
        current_statement__ = 20;
        stan::model::assign(L,
          genChol(Nsample, sigma, phi, dists, mod, pstream__),
          "assigning variable L");
      } else {
        current_statement__ = 18;
        stan::model::assign(L, L_data, "assigning variable L");
      }
      current_statement__ = 33;
      for (int t = 1; t <= nT; ++t) {
        current_statement__ = 31;
        if (stan::math::logical_gt(nT, 1)) {
          current_statement__ = 29;
          if (stan::math::logical_eq(t, 1)) {
            current_statement__ = 27;
            stan::model::assign(f,
              stan::math::multiply(
                stan::math::multiply((1 / (1 -
                  stan::math::pow(
                    stan::model::rvalue(ar, "ar", stan::model::index_uni(1)),
                    2))), L),
                stan::math::to_vector(
                  stan::model::rvalue(f_raw, "f_raw",
                    stan::model::index_min_max(1, Nsample)))),
              "assigning variable f", stan::model::index_min_max(1, Nsample));
          } else {
            current_statement__ = 25;
            stan::model::assign(f,
              stan::math::add(
                stan::math::multiply(
                  stan::math::multiply(
                    stan::model::rvalue(ar, "ar", stan::model::index_uni(1)),
                    L),
                  stan::model::deep_copy(
                    stan::model::rvalue(f, "f",
                      stan::model::index_min_max(((Nsample * (t - 2)) + 1),
                        ((t - 1) * Nsample))))),
                stan::math::multiply(L,
                  stan::math::to_vector(
                    stan::model::rvalue(f_raw, "f_raw",
                      stan::model::index_min_max(((Nsample * (t - 1)) + 1),
                        (t * Nsample)))))), "assigning variable f",
              stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t *
                Nsample)));
          }
        } else {
          current_statement__ = 23;
          stan::model::assign(f,
            stan::math::multiply(L, stan::math::to_vector(f_raw)),
            "assigning variable f");
        }
      }
      current_statement__ = 8;
      stan::math::check_greater_or_equal(function__, "sigma", sigma, 1e-05);
      current_statement__ = 9;
      stan::math::check_greater_or_equal(function__, "phi", phi, 1e-05);
      {
        current_statement__ = 40;
        if (stan::math::logical_negation(known_cov)) {
          current_statement__ = 37;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(phi_param,
                           stan::model::rvalue(prior_lscale, "prior_lscale",
                             stan::model::index_uni(1)),
                           stan::model::rvalue(prior_lscale, "prior_lscale",
                             stan::model::index_uni(2))));
          current_statement__ = 38;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(sigma_param,
                           stan::model::rvalue(prior_var, "prior_var",
                             stan::model::index_uni(1)),
                           stan::model::rvalue(prior_var, "prior_var",
                             stan::model::index_uni(2))));
        }
        current_statement__ = 42;
        if (stan::math::logical_gt(nT, 1)) {
          current_statement__ = 41;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(ar, 0, 1));
        }
        current_statement__ = 45;
        for (int q = 1; q <= Q; ++q) {
          current_statement__ = 43;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(
                           stan::model::rvalue(gamma, "gamma",
                             stan::model::index_uni(q)),
                           stan::model::rvalue(prior_linpred_mean,
                             "prior_linpred_mean", stan::model::index_uni(q)),
                           stan::model::rvalue(prior_linpred_sd,
                             "prior_linpred_sd", stan::model::index_uni(q))));
        }
        current_statement__ = 46;
        lp_accum__.add(stan::math::std_normal_lpdf<propto__>(f_raw));
        current_statement__ = 47;
        lp_accum__.add(stan::math::poisson_log_lpmf<propto__>(y,
                         stan::math::add(
                           stan::math::add(stan::math::multiply(X, gamma),
                             logpopdens), f)));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_lgcp_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<double> phi_param =
        std::vector<double>(phi_param_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      phi_param = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(1e-05, lp__,
                    phi_param_1dim__);
      std::vector<double> sigma_param =
        std::vector<double>(sigma_param_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      sigma_param = in__.template read_constrain_lb<
                      std::vector<local_scalar_t__>, jacobian__>(1e-05, lp__,
                      sigma_param_1dim__);
      Eigen::Matrix<double,-1,1> gamma =
        Eigen::Matrix<double,-1,1>::Constant(Q,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      gamma = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(Q);
      std::vector<double> ar =
        std::vector<double>(ar_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      ar = in__.template read_constrain_lub<std::vector<local_scalar_t__>,
             jacobian__>(-1, 1, lp__, ar_1dim__);
      std::vector<double> f_raw =
        std::vector<double>(f_raw_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      f_raw = in__.template read<std::vector<local_scalar_t__>>(f_raw_1dim__);
      Eigen::Matrix<double,-1,-1> L =
        Eigen::Matrix<double,-1,-1>::Constant(Nsample, Nsample,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> f =
        Eigen::Matrix<double,-1,1>::Constant(f_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      double sigma = std::numeric_limits<double>::quiet_NaN();
      double phi = std::numeric_limits<double>::quiet_NaN();
      out__.write(phi_param);
      out__.write(sigma_param);
      out__.write(gamma);
      out__.write(ar);
      out__.write(f_raw);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 17;
      if (known_cov) {
        current_statement__ = 14;
        sigma = sigma_data;
        current_statement__ = 15;
        phi = phi_data;
      } else {
        current_statement__ = 11;
        sigma = stan::model::rvalue(sigma_param, "sigma_param",
                  stan::model::index_uni(1));
        current_statement__ = 12;
        phi = stan::model::rvalue(phi_param, "phi_param",
                stan::model::index_uni(1));
      }
      current_statement__ = 22;
      if (stan::math::logical_negation(known_cov)) {
        current_statement__ = 20;
        stan::model::assign(L,
          genChol(Nsample, sigma, phi, dists, mod, pstream__),
          "assigning variable L");
      } else {
        current_statement__ = 18;
        stan::model::assign(L, L_data, "assigning variable L");
      }
      current_statement__ = 33;
      for (int t = 1; t <= nT; ++t) {
        current_statement__ = 31;
        if (stan::math::logical_gt(nT, 1)) {
          current_statement__ = 29;
          if (stan::math::logical_eq(t, 1)) {
            current_statement__ = 27;
            stan::model::assign(f,
              stan::math::multiply(
                stan::math::multiply((1 / (1 -
                  stan::math::pow(
                    stan::model::rvalue(ar, "ar", stan::model::index_uni(1)),
                    2))), L),
                stan::math::to_vector(
                  stan::model::rvalue(f_raw, "f_raw",
                    stan::model::index_min_max(1, Nsample)))),
              "assigning variable f", stan::model::index_min_max(1, Nsample));
          } else {
            current_statement__ = 25;
            stan::model::assign(f,
              stan::math::add(
                stan::math::multiply(
                  stan::math::multiply(
                    stan::model::rvalue(ar, "ar", stan::model::index_uni(1)),
                    L),
                  stan::model::deep_copy(
                    stan::model::rvalue(f, "f",
                      stan::model::index_min_max(((Nsample * (t - 2)) + 1),
                        ((t - 1) * Nsample))))),
                stan::math::multiply(L,
                  stan::math::to_vector(
                    stan::model::rvalue(f_raw, "f_raw",
                      stan::model::index_min_max(((Nsample * (t - 1)) + 1),
                        (t * Nsample)))))), "assigning variable f",
              stan::model::index_min_max(((Nsample * (t - 1)) + 1), (t *
                Nsample)));
          }
        } else {
          current_statement__ = 23;
          stan::model::assign(f,
            stan::math::multiply(L, stan::math::to_vector(f_raw)),
            "assigning variable f");
        }
      }
      current_statement__ = 8;
      stan::math::check_greater_or_equal(function__, "sigma", sigma, 1e-05);
      current_statement__ = 9;
      stan::math::check_greater_or_equal(function__, "phi", phi, 1e-05);
      if (emit_transformed_parameters__) {
        out__.write(L);
        out__.write(f);
        out__.write(sigma);
        out__.write(phi);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> y_grid_predict =
        Eigen::Matrix<double,-1,1>::Constant(y_grid_predict_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 36;
      for (int i = 1; i <= (Nsample * nT); ++i) {
        current_statement__ = 34;
        stan::model::assign(y_grid_predict,
          stan::math::exp(
            ((stan::math::multiply(
                stan::model::rvalue(X, "X", stan::model::index_uni(i),
                  stan::model::index_omni()), gamma) +
            stan::model::rvalue(logpopdens, "logpopdens",
              stan::model::index_uni(i))) +
            stan::model::rvalue(f, "f", stan::model::index_uni(i)))),
          "assigning variable y_grid_predict", stan::model::index_uni(i));
      }
      out__.write(y_grid_predict);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> phi_param =
        std::vector<local_scalar_t__>(phi_param_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(phi_param,
        in__.read<std::vector<local_scalar_t__>>(phi_param_1dim__),
        "assigning variable phi_param");
      out__.write_free_lb(1e-05, phi_param);
      std::vector<local_scalar_t__> sigma_param =
        std::vector<local_scalar_t__>(sigma_param_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(sigma_param,
        in__.read<std::vector<local_scalar_t__>>(sigma_param_1dim__),
        "assigning variable sigma_param");
      out__.write_free_lb(1e-05, sigma_param);
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Q, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(gamma,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(Q),
        "assigning variable gamma");
      out__.write(gamma);
      std::vector<local_scalar_t__> ar =
        std::vector<local_scalar_t__>(ar_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(ar,
        in__.read<std::vector<local_scalar_t__>>(ar_1dim__),
        "assigning variable ar");
      out__.write_free_lub(-1, 1, ar);
      std::vector<local_scalar_t__> f_raw =
        std::vector<local_scalar_t__>(f_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(f_raw,
        in__.read<std::vector<local_scalar_t__>>(f_raw_1dim__),
        "assigning variable f_raw");
      out__.write(f_raw);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "phi_param",
        "double", std::vector<size_t>{static_cast<size_t>(phi_param_1dim__)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_param",
        "double",
        std::vector<size_t>{static_cast<size_t>(sigma_param_1dim__)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "gamma", "double",
        std::vector<size_t>{static_cast<size_t>(Q)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "ar", "double",
        std::vector<size_t>{static_cast<size_t>(ar_1dim__)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "f_raw", "double",
        std::vector<size_t>{static_cast<size_t>(f_raw_1dim__)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> phi_param =
        std::vector<local_scalar_t__>(phi_param_1dim__, DUMMY_VAR__);
      current_statement__ = 1;
      phi_param = context__.vals_r("phi_param");
      out__.write_free_lb(1e-05, phi_param);
      std::vector<local_scalar_t__> sigma_param =
        std::vector<local_scalar_t__>(sigma_param_1dim__, DUMMY_VAR__);
      current_statement__ = 2;
      sigma_param = context__.vals_r("sigma_param");
      out__.write_free_lb(1e-05, sigma_param);
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(Q, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 3;
        gamma_flat__ = context__.vals_r("gamma");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(gamma, gamma_flat__[(pos__ - 1)],
            "assigning variable gamma", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(gamma);
      std::vector<local_scalar_t__> ar =
        std::vector<local_scalar_t__>(ar_1dim__, DUMMY_VAR__);
      current_statement__ = 4;
      ar = context__.vals_r("ar");
      out__.write_free_lub(-1, 1, ar);
      std::vector<local_scalar_t__> f_raw =
        std::vector<local_scalar_t__>(f_raw_1dim__, DUMMY_VAR__);
      current_statement__ = 5;
      f_raw = context__.vals_r("f_raw");
      out__.write(f_raw);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"phi_param", "sigma_param", "gamma",
                "ar", "f_raw"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"L", "f", "sigma", "phi"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"y_grid_predict"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    phi_param_1dim__)},
                std::vector<size_t>{static_cast<size_t>(sigma_param_1dim__)},
                std::vector<size_t>{static_cast<size_t>(Q)},
                std::vector<size_t>{static_cast<size_t>(ar_1dim__)},
                std::vector<size_t>{static_cast<size_t>(f_raw_1dim__)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(Nsample),
               static_cast<size_t>(Nsample)},
             std::vector<size_t>{static_cast<size_t>(f_1dim__)},
             std::vector<size_t>{}, std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(y_grid_predict_1dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= phi_param_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "phi_param" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= sigma_param_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_param" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= ar_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "ar" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= f_raw_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "f_raw" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= Nsample; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= Nsample; ++sym2__) {
          param_names__.emplace_back(std::string() + "L" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= f_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "f" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "sigma");
      param_names__.emplace_back(std::string() + "phi");
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= y_grid_predict_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_grid_predict" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= phi_param_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "phi_param" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= sigma_param_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_param" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= ar_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "ar" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= f_raw_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "f_raw" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= Nsample; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= Nsample; ++sym2__) {
          param_names__.emplace_back(std::string() + "L" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= f_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "f" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "sigma");
      param_names__.emplace_back(std::string() + "phi");
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= y_grid_predict_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "y_grid_predict" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"phi_param\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(phi_param_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_param\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(sigma_param_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(Q) + "},\"block\":\"parameters\"},{\"name\":\"ar\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(ar_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"f_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(f_raw_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"L\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(Nsample) + ",\"cols\":" + std::to_string(Nsample) + "},\"block\":\"transformed_parameters\"},{\"name\":\"f\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(f_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"y_grid_predict\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_grid_predict_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"phi_param\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(phi_param_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_param\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(sigma_param_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(Q) + "},\"block\":\"parameters\"},{\"name\":\"ar\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(ar_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"f_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(f_raw_1dim__) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"L\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(Nsample) + ",\"cols\":" + std::to_string(Nsample) + "},\"block\":\"transformed_parameters\"},{\"name\":\"f\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(f_1dim__) + "},\"block\":\"transformed_parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"y_grid_predict\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(y_grid_predict_1dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((phi_param_1dim__ + sigma_param_1dim__) +
      Q) + ar_1dim__) + f_raw_1dim__);
    const size_t num_transformed = emit_transformed_parameters * (((((Nsample
      * Nsample) + f_1dim__) + 1) + 1));
    const size_t num_gen_quantities = emit_generated_quantities *
      (y_grid_predict_1dim__);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((phi_param_1dim__ + sigma_param_1dim__) +
      Q) + ar_1dim__) + f_raw_1dim__);
    const size_t num_transformed = emit_transformed_parameters * (((((Nsample
      * Nsample) + f_1dim__) + 1) + 1));
    const size_t num_gen_quantities = emit_generated_quantities *
      (y_grid_predict_1dim__);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_lgcp_namespace::model_lgcp;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_lgcp_namespace::profiles__;
}
#endif
#endif
