% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsyslog.R
\name{set_syslog_mask}
\alias{set_syslog_mask}
\title{Set the System Log Priority Mask}
\usage{
set_syslog_mask(level)
}
\arguments{
\item{level}{Mask (hide) messages below this priority level. One of
\code{"DEBUG"}, \code{"INFO"}, \code{"NOTICE"}, \code{"WARNING"},
\code{"ERR"}, \code{"CRITICAL"}, or \code{"ALERT"} -- in that order of
priority. See \href{https://tools.ietf.org/html/rfc5424#page-11}{RFC 5424}
for the basis of this schema.}
}
\description{
\code{set_syslog_mask} can be used to prevent messages below a priority
level from being written to the system log.
}
\examples{
\dontrun{
open_syslog("my_script")
syslog("This message is visible.", level = "INFO")
set_syslog_mask("WARNING")
syslog("No longer visible.", level = "INFO")
syslog("Still visible.", level = "WARNING")
close_syslog()
}

}
