% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_db_wrapper_fns.R
\name{dbDrop}
\alias{dbDrop}
\title{Drop table/view/schema.}
\usage{
dbDrop(conn, name, type = c("table", "schema", "view",
  "materialized view"), ifexists = FALSE, cascade = FALSE,
  display = TRUE, exec = TRUE)
}
\arguments{
\item{conn}{A connection object.}

\item{name}{A character string specifying a PostgreSQL table, schema, or view name.}

\item{type}{The type of the object to drop, either \code{"table"}, \code{"schema"},
\code{"view"}, or \code{"materialized view"}.}

\item{ifexists}{Do not throw an error if the object does not
exist. A notice is issued in this case.}

\item{cascade}{Automatically drop objects that depend on the object
(such as views).}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}
}
\value{
\code{TRUE} if the table/schema/view was successfully
    dropped.
}
\description{
Drop a table, a view or a schema.
}
\examples{
## examples use a dummy connection from DBI package
conn<-DBI::ANSI()
dbDrop(conn, name = c("schema", "view_name"), type = "view", exec = FALSE)
dbDrop(conn, name = "test_schema", type = "schema", cascade = "TRUE", exec = FALSE)
}
\seealso{
The PostgreSQL documentation:
    \url{http://www.postgresql.org/docs/current/static/sql-droptable.html},
    \url{http://www.postgresql.org/docs/current/static/sql-dropview.html},
    \url{http://www.postgresql.org/docs/current/static/sql-dropschema.html}
}
\author{
Mathieu Basille \email{basille@ufl.edu}
}
