% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollup.R
\name{with_cube}
\alias{with_cube}
\title{with_cube}
\usage{
with_cube(grouped_df)
}
\arguments{
\item{grouped_df}{'grouped_df' class}
}
\value{
A list of 'grouped_df' class. each 'grouped_df' object has a different grouping level.
}
\description{
Compute total amounts at different group levels, producing multiple subtotals. With the 'with_cube' clause following 'group_by', you can aggregate multiple grouping variables in one operation. This reflects the 'WITH CUBE' operations in 'SQL'.
}
\examples{
mtcars \%>\% group_by(vs, am) \%>\% grouping_sets("vs","am",c("vs","am"))
mtcars \%>\% group_by(vs, am) \%>\% with_rollup() 
mtcars \%>\% group_by(vs, am) \%>\% with_cube() 
}
