% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_LatLon.R
\name{get_latlon}
\alias{get_latlon}
\title{get latitude and longitude from Google polyline}
\usage{
get_latlon(polyline, key)
}
\arguments{
\item{polyline}{a map polyline returned for an activity from the API}

\item{key}{chr string of Google API key for elevation data, passed to \code{\link[googleway]{google_elevation}}}
}
\value{
dataframe of latitude and longitudes with a column for the unique identifier
}
\description{
get latitude and longitude from Google polyline
}
\examples{
\dontrun{
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))

my_acts <- get_activity_list(stoken)
acts_data <- compile_activities(my_acts)

# get lat and lon for a single activity
polyline <- acts_data$map.summary_polyline[[1]]
get_latlon(polyline, key = mykey)
}
}
\author{
Daniel Padfield, Marcus Beck
}
\concept{token}
