% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_count.R
\name{pystr_count}
\alias{pystr_count}
\title{Count the occurrences of a substring.}
\usage{
pystr_count(str, sub, start = 1, end = max(nchar(str)))
}
\arguments{
\item{str}{A character vector.}

\item{sub}{A character string.}

\item{start}{An integer.}

\item{end}{An integer.}
}
\value{
A numeric vector.
}
\description{
Return the number of non-overlapping occurrences of substring \code{sub} in the range \code{start, end}.
}
\examples{
pystr_count("ababab", "aba")
pystr_count("abcxyzabc123", "abc")
pystr_count("a--b--c", "--", 4)
pystr_count(c("one", "two", "three"), "e")
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.count}
}

