% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_object_S3_methods.R
\name{plot.pvEBayes}
\alias{plot.pvEBayes}
\title{Plotting method for a pvEBayes object}
\usage{
\method{plot}{pvEBayes}(x, type = "eyeplot", ...)
}
\arguments{
\item{x}{a \code{pvEBayes} object, which is the output of the function
\link{pvEBayes} or \link{pvEBayes_tune}.}

\item{type}{character string determining the type of plot to show.
Available choices are \code{"eyeplot"} which calls \link{eyeplot_pvEBayes} and
\code{"heatmap"} which calls \link{heatmap_pvEBayes}, with the additional arguments
supplied in ...}

\item{...}{additional arguments passed to heatmap_pvEBayes or eyeplot_pvEBayes.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
This function defines the S3 \code{plot} method for objects of class
\code{pvEBayes}.
}
\examples{

obj <- pvEBayes(statin2025_44, model = "general-gamma", alpha = 0.5)
plot(obj, type = "eyeplot")
}
