% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_top_portfolio.R
\name{add_top_portfolio}
\alias{add_top_portfolio}
\title{Add a top portfolio}
\usage{
add_top_portfolio(x, number_solutions = 10)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object.}

\item{number_solutions}{\code{integer} number of solutions required.
Defaults to 10.}
}
\value{
An updated \code{\link[=problem]{problem()}} object with the portfolio added to it.
}
\description{
Generate a portfolio of solutions for a conservation planning
problem by finding a pre-specified number of solutions that
are closest to optimality (i.e, the top solutions).
}
\details{
This strategy for generating a portfolio requires problems to
be solved using the \emph{Gurobi} software suite (i.e., using
\code{\link[=add_gurobi_solver]{add_gurobi_solver()}}. Specifically, version 8.0.0 (or greater)
of the \pkg{gurobi} package must be installed.
Note that the number of solutions returned may be less than the argument to
\code{number_solutions}, if the total number of feasible solutions
is less than the number of solutions requested.
}
\examples{
\dontrun{
# set seed for reproducibility
set.seed(600)

# load data
sim_pu_raster <- get_sim_pu_raster()
sim_features <- get_sim_features()
sim_zones_pu_raster <- get_sim_zones_pu_raster()
sim_zones_features <- get_sim_zones_features()

# create minimal problem with a portfolio for the top 5 solutions
p1 <-
  problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.05) \%>\%
  add_top_portfolio(number_solutions = 5) \%>\%
  add_default_solver(gap = 0, verbose = FALSE)

# solve problem and generate portfolio
s1 <- solve(p1)

# convert portfolio into a multi-layer raster
s1 <- terra::rast(s1)

# print number of solutions found
print(terra::nlyr(s1))

# plot solutions
plot(s1, axes = FALSE)

# create multi-zone problem with a portfolio for the top 5 solutions
p2 <-
  problem(sim_zones_pu_raster, sim_zones_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(matrix(runif(15, 0.1, 0.2), nrow = 5, ncol = 3)) \%>\%
  add_top_portfolio(number_solutions = 5) \%>\%
  add_default_solver(gap = 0, verbose = FALSE)

# solve problem and generate portfolio
s2 <- solve(p2)

# convert each solution in the portfolio into a single category layer
s2 <- terra::rast(lapply(s2, category_layer))

# print number of solutions found
print(terra::nlyr(s2))

# plot solutions in portfolio
plot(s2, axes = FALSE)
}
}
\seealso{
See \link{portfolios} for an overview of all functions for adding a portfolio.

Other portfolios: 
\code{\link{add_cuts_portfolio}()},
\code{\link{add_default_portfolio}()},
\code{\link{add_extra_portfolio}()},
\code{\link{add_gap_portfolio}()},
\code{\link{add_shuffle_portfolio}()}
}
\concept{portfolios}
