% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_nmrnormRes.R
\name{summary-nmrnormRes}
\alias{summary-nmrnormRes}
\alias{summary.nmrnormRes}
\title{Summary of nmrnormRes Object}
\usage{
\method{summary}{nmrnormRes}(object, ...)
}
\arguments{
\item{object}{object of type nmrnormRes, created by
\code{\link{normalize_nmr}}}

\item{...}{further arguments passed to or from other methods.}
}
\value{
data frame object
}
\description{
For creating a summary of an S3 object of type 'nmrnormRes'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mynmr <- edata_transform(
  omicsData = nmr_identified_object,
  data_scale = "log2"
)
nmr_norm <- normalize_nmr(
  omicsData = mynmr, apply_norm = FALSE,
  sample_property_cname = "Concentration"
)
mysummary <- summary(nmr_norm)
\dontshow{\}) # examplesIf}
}
